@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin

import com.pulumi.aws.opensearch.VpcEndpointArgs.builder
import com.pulumi.aws.opensearch.kotlin.inputs.VpcEndpointVpcOptionsArgs
import com.pulumi.aws.opensearch.kotlin.inputs.VpcEndpointVpcOptionsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Manages an [AWS Opensearch VPC Endpoint](https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_CreateVpcEndpoint.html). Creates an Amazon OpenSearch Service-managed VPC endpoint.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const foo = new aws.opensearch.VpcEndpoint("foo", {
 *     domainArn: domain1.arn,
 *     vpcOptions: {
 *         securityGroupIds: [
 *             test.id,
 *             test2.id,
 *         ],
 *         subnetIds: [
 *             testAwsSubnet.id,
 *             test2AwsSubnet.id,
 *         ],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * foo = aws.opensearch.VpcEndpoint("foo",
 *     domain_arn=domain1["arn"],
 *     vpc_options={
 *         "security_group_ids": [
 *             test["id"],
 *             test2["id"],
 *         ],
 *         "subnet_ids": [
 *             test_aws_subnet["id"],
 *             test2_aws_subnet["id"],
 *         ],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = new Aws.OpenSearch.VpcEndpoint("foo", new()
 *     {
 *         DomainArn = domain1.Arn,
 *         VpcOptions = new Aws.OpenSearch.Inputs.VpcEndpointVpcOptionsArgs
 *         {
 *             SecurityGroupIds = new[]
 *             {
 *                 test.Id,
 *                 test2.Id,
 *             },
 *             SubnetIds = new[]
 *             {
 *                 testAwsSubnet.Id,
 *                 test2AwsSubnet.Id,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/opensearch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := opensearch.NewVpcEndpoint(ctx, "foo", &opensearch.VpcEndpointArgs{
 * 			DomainArn: pulumi.Any(domain1.Arn),
 * 			VpcOptions: &opensearch.VpcEndpointVpcOptionsArgs{
 * 				SecurityGroupIds: pulumi.StringArray{
 * 					test.Id,
 * 					test2.Id,
 * 				},
 * 				SubnetIds: pulumi.StringArray{
 * 					testAwsSubnet.Id,
 * 					test2AwsSubnet.Id,
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.VpcEndpoint;
 * import com.pulumi.aws.opensearch.VpcEndpointArgs;
 * import com.pulumi.aws.opensearch.inputs.VpcEndpointVpcOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new VpcEndpoint("foo", VpcEndpointArgs.builder()
 *             .domainArn(domain1.arn())
 *             .vpcOptions(VpcEndpointVpcOptionsArgs.builder()
 *                 .securityGroupIds(
 *                     test.id(),
 *                     test2.id())
 *                 .subnetIds(
 *                     testAwsSubnet.id(),
 *                     test2AwsSubnet.id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: aws:opensearch:VpcEndpoint
 *     properties:
 *       domainArn: ${domain1.arn}
 *       vpcOptions:
 *         securityGroupIds:
 *           - ${test.id}
 *           - ${test2.id}
 *         subnetIds:
 *           - ${testAwsSubnet.id}
 *           - ${test2AwsSubnet.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import OpenSearch VPC endpoint connections using the `id`. For example:
 * ```sh
 * $ pulumi import aws:opensearch/vpcEndpoint:VpcEndpoint example endpoint-id
 * ```
 * @property domainArn Specifies the Amazon Resource Name (ARN) of the domain to create the endpoint for
 * @property vpcOptions Options to specify the subnets and security groups for the endpoint.
 */
public data class VpcEndpointArgs(
    public val domainArn: Output<String>? = null,
    public val vpcOptions: Output<VpcEndpointVpcOptionsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.opensearch.VpcEndpointArgs> {
    override fun toJava(): com.pulumi.aws.opensearch.VpcEndpointArgs =
        com.pulumi.aws.opensearch.VpcEndpointArgs.builder()
            .domainArn(domainArn?.applyValue({ args0 -> args0 }))
            .vpcOptions(vpcOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VpcEndpointArgs].
 */
@PulumiTagMarker
public class VpcEndpointArgsBuilder internal constructor() {
    private var domainArn: Output<String>? = null

    private var vpcOptions: Output<VpcEndpointVpcOptionsArgs>? = null

    /**
     * @param value Specifies the Amazon Resource Name (ARN) of the domain to create the endpoint for
     */
    @JvmName("lxuhfkwcihubwiku")
    public suspend fun domainArn(`value`: Output<String>) {
        this.domainArn = value
    }

    /**
     * @param value Options to specify the subnets and security groups for the endpoint.
     */
    @JvmName("dasaisrgbqrrfvwg")
    public suspend fun vpcOptions(`value`: Output<VpcEndpointVpcOptionsArgs>) {
        this.vpcOptions = value
    }

    /**
     * @param value Specifies the Amazon Resource Name (ARN) of the domain to create the endpoint for
     */
    @JvmName("gaigcqgyufxehoey")
    public suspend fun domainArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainArn = mapped
    }

    /**
     * @param value Options to specify the subnets and security groups for the endpoint.
     */
    @JvmName("pcmimdsfiqoaytnj")
    public suspend fun vpcOptions(`value`: VpcEndpointVpcOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcOptions = mapped
    }

    /**
     * @param argument Options to specify the subnets and security groups for the endpoint.
     */
    @JvmName("sunwjluavitgjgmn")
    public suspend fun vpcOptions(argument: suspend VpcEndpointVpcOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = VpcEndpointVpcOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vpcOptions = mapped
    }

    internal fun build(): VpcEndpointArgs = VpcEndpointArgs(
        domainArn = domainArn,
        vpcOptions = vpcOptions,
    )
}
