@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.inputs

import com.pulumi.aws.opensearch.inputs.DomainAutoTuneOptionsMaintenanceScheduleDurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property unit Unit of time specifying the duration of an Auto-Tune maintenance window. Valid values: `HOURS`.
 * @property value An integer specifying the value of the duration of an Auto-Tune maintenance window.
 */
public data class DomainAutoTuneOptionsMaintenanceScheduleDurationArgs(
    public val unit: Output<String>,
    public val `value`: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.aws.opensearch.inputs.DomainAutoTuneOptionsMaintenanceScheduleDurationArgs> {
    override fun toJava(): com.pulumi.aws.opensearch.inputs.DomainAutoTuneOptionsMaintenanceScheduleDurationArgs =
        com.pulumi.aws.opensearch.inputs.DomainAutoTuneOptionsMaintenanceScheduleDurationArgs.builder()
            .unit(unit.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainAutoTuneOptionsMaintenanceScheduleDurationArgs].
 */
@PulumiTagMarker
public class DomainAutoTuneOptionsMaintenanceScheduleDurationArgsBuilder internal constructor() {
    private var unit: Output<String>? = null

    private var `value`: Output<Int>? = null

    /**
     * @param value Unit of time specifying the duration of an Auto-Tune maintenance window. Valid values: `HOURS`.
     */
    @JvmName("xpxmdhngmlybocvc")
    public suspend fun unit(`value`: Output<String>) {
        this.unit = value
    }

    /**
     * @param value An integer specifying the value of the duration of an Auto-Tune maintenance window.
     */
    @JvmName("mtyigddvcovqduye")
    public suspend fun `value`(`value`: Output<Int>) {
        this.`value` = value
    }

    /**
     * @param value Unit of time specifying the duration of an Auto-Tune maintenance window. Valid values: `HOURS`.
     */
    @JvmName("nmebdyqteqyndxag")
    public suspend fun unit(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.unit = mapped
    }

    /**
     * @param value An integer specifying the value of the duration of an Auto-Tune maintenance window.
     */
    @JvmName("wdadjdhfcnfkeqnj")
    public suspend fun `value`(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): DomainAutoTuneOptionsMaintenanceScheduleDurationArgs =
        DomainAutoTuneOptionsMaintenanceScheduleDurationArgs(
            unit = unit ?: throw PulumiNullFieldException("unit"),
            `value` = `value` ?: throw PulumiNullFieldException("value"),
        )
}
