@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.inputs

import com.pulumi.aws.opensearch.inputs.DomainNodeToNodeEncryptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Whether to enable node-to-node encryption. If the `node_to_node_encryption` block is not provided then this defaults to `false`. Enabling node-to-node encryption of a new domain requires an `engine_version` of `OpenSearch_X.Y` or `Elasticsearch_6.0` or greater.
 */
public data class DomainNodeToNodeEncryptionArgs(
    public val enabled: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.aws.opensearch.inputs.DomainNodeToNodeEncryptionArgs> {
    override fun toJava(): com.pulumi.aws.opensearch.inputs.DomainNodeToNodeEncryptionArgs =
        com.pulumi.aws.opensearch.inputs.DomainNodeToNodeEncryptionArgs.builder()
            .enabled(enabled.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainNodeToNodeEncryptionArgs].
 */
@PulumiTagMarker
public class DomainNodeToNodeEncryptionArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    /**
     * @param value Whether to enable node-to-node encryption. If the `node_to_node_encryption` block is not provided then this defaults to `false`. Enabling node-to-node encryption of a new domain requires an `engine_version` of `OpenSearch_X.Y` or `Elasticsearch_6.0` or greater.
     */
    @JvmName("kklditmlttdulqgu")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Whether to enable node-to-node encryption. If the `node_to_node_encryption` block is not provided then this defaults to `false`. Enabling node-to-node encryption of a new domain requires an `engine_version` of `OpenSearch_X.Y` or `Elasticsearch_6.0` or greater.
     */
    @JvmName("okfjbxqffcwinkjm")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): DomainNodeToNodeEncryptionArgs = DomainNodeToNodeEncryptionArgs(
        enabled = enabled ?: throw PulumiNullFieldException("enabled"),
    )
}
