@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.inputs

import com.pulumi.aws.opensearch.inputs.DomainOffPeakWindowOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Enabled disabled toggle for off-peak update window.
 * @property offPeakWindow
 */
public data class DomainOffPeakWindowOptionsArgs(
    public val enabled: Output<Boolean>? = null,
    public val offPeakWindow: Output<DomainOffPeakWindowOptionsOffPeakWindowArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.opensearch.inputs.DomainOffPeakWindowOptionsArgs> {
    override fun toJava(): com.pulumi.aws.opensearch.inputs.DomainOffPeakWindowOptionsArgs =
        com.pulumi.aws.opensearch.inputs.DomainOffPeakWindowOptionsArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .offPeakWindow(offPeakWindow?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DomainOffPeakWindowOptionsArgs].
 */
@PulumiTagMarker
public class DomainOffPeakWindowOptionsArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var offPeakWindow: Output<DomainOffPeakWindowOptionsOffPeakWindowArgs>? = null

    /**
     * @param value Enabled disabled toggle for off-peak update window.
     */
    @JvmName("hpeeufnlfhtnlyxv")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value
     */
    @JvmName("atkqjhhwiunabdiy")
    public suspend fun offPeakWindow(`value`: Output<DomainOffPeakWindowOptionsOffPeakWindowArgs>) {
        this.offPeakWindow = value
    }

    /**
     * @param value Enabled disabled toggle for off-peak update window.
     */
    @JvmName("snwwodphypqdttsr")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value
     */
    @JvmName("vjkycqgvsxofqbbu")
    public suspend fun offPeakWindow(`value`: DomainOffPeakWindowOptionsOffPeakWindowArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offPeakWindow = mapped
    }

    /**
     * @param argument
     */
    @JvmName("cfkuaenrvcsctvpv")
    public suspend fun offPeakWindow(argument: suspend DomainOffPeakWindowOptionsOffPeakWindowArgsBuilder.() -> Unit) {
        val toBeMapped = DomainOffPeakWindowOptionsOffPeakWindowArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.offPeakWindow = mapped
    }

    internal fun build(): DomainOffPeakWindowOptionsArgs = DomainOffPeakWindowOptionsArgs(
        enabled = enabled,
        offPeakWindow = offPeakWindow,
    )
}
