@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.inputs

import com.pulumi.aws.opensearch.inputs.DomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property hours Starting hour of the 10-hour window for updates
 * @property minutes Starting minute of the 10-hour window for updates
 */
public data class DomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeArgs(
    public val hours: Output<Int>? = null,
    public val minutes: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.opensearch.inputs.DomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeArgs> {
    override fun toJava(): com.pulumi.aws.opensearch.inputs.DomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeArgs =
        com.pulumi.aws.opensearch.inputs.DomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeArgs.builder()
            .hours(hours?.applyValue({ args0 -> args0 }))
            .minutes(minutes?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeArgs].
 */
@PulumiTagMarker
public class DomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeArgsBuilder internal constructor() {
    private var hours: Output<Int>? = null

    private var minutes: Output<Int>? = null

    /**
     * @param value Starting hour of the 10-hour window for updates
     */
    @JvmName("imrbblskdrhcpfto")
    public suspend fun hours(`value`: Output<Int>) {
        this.hours = value
    }

    /**
     * @param value Starting minute of the 10-hour window for updates
     */
    @JvmName("ldcfywwmgjwqmaue")
    public suspend fun minutes(`value`: Output<Int>) {
        this.minutes = value
    }

    /**
     * @param value Starting hour of the 10-hour window for updates
     */
    @JvmName("goxqkpbgghqpujsk")
    public suspend fun hours(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hours = mapped
    }

    /**
     * @param value Starting minute of the 10-hour window for updates
     */
    @JvmName("xsokmgchkdnnrayn")
    public suspend fun minutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minutes = mapped
    }

    internal fun build(): DomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeArgs =
        DomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeArgs(
            hours = hours,
            minutes = minutes,
        )
}
