@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.inputs

import com.pulumi.aws.opensearch.inputs.DomainVpcOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property availabilityZones If the domain was created inside a VPC, the names of the availability zones the configured `subnet_ids` were created inside.
 * @property securityGroupIds List of VPC Security Group IDs to be applied to the OpenSearch domain endpoints. If omitted, the default Security Group for the VPC will be used.
 * @property subnetIds List of VPC Subnet IDs for the OpenSearch domain endpoints to be created in.
 * @property vpcId If the domain was created inside a VPC, the ID of the VPC.
 */
public data class DomainVpcOptionsArgs(
    public val availabilityZones: Output<List<String>>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val subnetIds: Output<List<String>>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.opensearch.inputs.DomainVpcOptionsArgs> {
    override fun toJava(): com.pulumi.aws.opensearch.inputs.DomainVpcOptionsArgs =
        com.pulumi.aws.opensearch.inputs.DomainVpcOptionsArgs.builder()
            .availabilityZones(availabilityZones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainVpcOptionsArgs].
 */
@PulumiTagMarker
public class DomainVpcOptionsArgsBuilder internal constructor() {
    private var availabilityZones: Output<List<String>>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var subnetIds: Output<List<String>>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value If the domain was created inside a VPC, the names of the availability zones the configured `subnet_ids` were created inside.
     */
    @JvmName("ifvoxlgwsyvbjibp")
    public suspend fun availabilityZones(`value`: Output<List<String>>) {
        this.availabilityZones = value
    }

    @JvmName("vcikdnsfbytymmkg")
    public suspend fun availabilityZones(vararg values: Output<String>) {
        this.availabilityZones = Output.all(values.asList())
    }

    /**
     * @param values If the domain was created inside a VPC, the names of the availability zones the configured `subnet_ids` were created inside.
     */
    @JvmName("opcmwksvvhtsyyek")
    public suspend fun availabilityZones(values: List<Output<String>>) {
        this.availabilityZones = Output.all(values)
    }

    /**
     * @param value List of VPC Security Group IDs to be applied to the OpenSearch domain endpoints. If omitted, the default Security Group for the VPC will be used.
     */
    @JvmName("mkpjbmolqpfgieah")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("wndrffriqcbpfmrf")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values List of VPC Security Group IDs to be applied to the OpenSearch domain endpoints. If omitted, the default Security Group for the VPC will be used.
     */
    @JvmName("dbtkcbsnqdhthgbl")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value List of VPC Subnet IDs for the OpenSearch domain endpoints to be created in.
     */
    @JvmName("urhxbhkhxrduoxxl")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("hpjkhrprsfgfpggw")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values List of VPC Subnet IDs for the OpenSearch domain endpoints to be created in.
     */
    @JvmName("ccteryybikkbwhap")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value If the domain was created inside a VPC, the ID of the VPC.
     */
    @JvmName("otdoqrnkdyueygcx")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value If the domain was created inside a VPC, the names of the availability zones the configured `subnet_ids` were created inside.
     */
    @JvmName("rewhbsbmlcrrwbqf")
    public suspend fun availabilityZones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param values If the domain was created inside a VPC, the names of the availability zones the configured `subnet_ids` were created inside.
     */
    @JvmName("qqgqmitthitomjmy")
    public suspend fun availabilityZones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param value List of VPC Security Group IDs to be applied to the OpenSearch domain endpoints. If omitted, the default Security Group for the VPC will be used.
     */
    @JvmName("dkemceyairyvqckr")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values List of VPC Security Group IDs to be applied to the OpenSearch domain endpoints. If omitted, the default Security Group for the VPC will be used.
     */
    @JvmName("trvflooyknvxqikj")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value List of VPC Subnet IDs for the OpenSearch domain endpoints to be created in.
     */
    @JvmName("pusqtgxdslserplv")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values List of VPC Subnet IDs for the OpenSearch domain endpoints to be created in.
     */
    @JvmName("trpwgxbmjevxmnej")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value If the domain was created inside a VPC, the ID of the VPC.
     */
    @JvmName("qhocxdcsqgkhxpxo")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): DomainVpcOptionsArgs = DomainVpcOptionsArgs(
        availabilityZones = availabilityZones,
        securityGroupIds = securityGroupIds,
        subnetIds = subnetIds,
        vpcId = vpcId,
    )
}
