@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.inputs

import com.pulumi.aws.opensearch.inputs.GetDomainOffPeakWindowOptions.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Enabled disabled toggle for off-peak update window
 * @property offPeakWindows
 */
public data class GetDomainOffPeakWindowOptions(
    public val enabled: Boolean,
    public val offPeakWindows: List<GetDomainOffPeakWindowOptionsOffPeakWindow>,
) : ConvertibleToJava<com.pulumi.aws.opensearch.inputs.GetDomainOffPeakWindowOptions> {
    override fun toJava(): com.pulumi.aws.opensearch.inputs.GetDomainOffPeakWindowOptions =
        com.pulumi.aws.opensearch.inputs.GetDomainOffPeakWindowOptions.builder()
            .enabled(enabled.let({ args0 -> args0 }))
            .offPeakWindows(
                offPeakWindows.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GetDomainOffPeakWindowOptions].
 */
@PulumiTagMarker
public class GetDomainOffPeakWindowOptionsBuilder internal constructor() {
    private var enabled: Boolean? = null

    private var offPeakWindows: List<GetDomainOffPeakWindowOptionsOffPeakWindow>? = null

    /**
     * @param value Enabled disabled toggle for off-peak update window
     */
    @JvmName("ftfgoqbdybdfdvrx")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.enabled = mapped
    }

    /**
     * @param value
     */
    @JvmName("tfkhvcvthrmdkhpb")
    public suspend fun offPeakWindows(`value`: List<GetDomainOffPeakWindowOptionsOffPeakWindow>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.offPeakWindows = mapped
    }

    /**
     * @param argument
     */
    @JvmName("qrbkqliplnswwyxn")
    public suspend fun offPeakWindows(argument: List<suspend GetDomainOffPeakWindowOptionsOffPeakWindowBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetDomainOffPeakWindowOptionsOffPeakWindowBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.offPeakWindows = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ljexpknwlnulfuya")
    public suspend fun offPeakWindows(vararg argument: suspend GetDomainOffPeakWindowOptionsOffPeakWindowBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetDomainOffPeakWindowOptionsOffPeakWindowBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.offPeakWindows = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ivbyjbsqhlehodgl")
    public suspend fun offPeakWindows(argument: suspend GetDomainOffPeakWindowOptionsOffPeakWindowBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetDomainOffPeakWindowOptionsOffPeakWindowBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.offPeakWindows = mapped
    }

    /**
     * @param values
     */
    @JvmName("ikakwixkyubtmjqe")
    public suspend fun offPeakWindows(vararg values: GetDomainOffPeakWindowOptionsOffPeakWindow) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.offPeakWindows = mapped
    }

    internal fun build(): GetDomainOffPeakWindowOptions = GetDomainOffPeakWindowOptions(
        enabled = enabled ?: throw PulumiNullFieldException("enabled"),
        offPeakWindows = offPeakWindows ?: throw PulumiNullFieldException("offPeakWindows"),
    )
}
