@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.inputs

import com.pulumi.aws.opensearch.inputs.GetServerlessAccessPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getServerlessAccessPolicy.
 * @property name Name of the policy.
 * @property type Type of access policy. Must be `data`.
 */
public data class GetServerlessAccessPolicyPlainArgs(
    public val name: String,
    public val type: String,
) : ConvertibleToJava<com.pulumi.aws.opensearch.inputs.GetServerlessAccessPolicyPlainArgs> {
    override fun toJava(): com.pulumi.aws.opensearch.inputs.GetServerlessAccessPolicyPlainArgs =
        com.pulumi.aws.opensearch.inputs.GetServerlessAccessPolicyPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .type(type.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServerlessAccessPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetServerlessAccessPolicyPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var type: String? = null

    /**
     * @param value Name of the policy.
     */
    @JvmName("xdtyyydqmahfwvdd")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Type of access policy. Must be `data`.
     */
    @JvmName("vtbddibqshwsvosf")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.type = mapped
    }

    internal fun build(): GetServerlessAccessPolicyPlainArgs = GetServerlessAccessPolicyPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
