@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.inputs

import com.pulumi.aws.opensearch.inputs.GetServerlessCollectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getServerlessCollection.
 * @property id ID of the collection. Either `id` or `name` must be provided.
 * @property name Name of the collection. Either `name` or `id` must be provided.
 */
public data class GetServerlessCollectionPlainArgs(
    public val id: String? = null,
    public val name: String? = null,
) : ConvertibleToJava<com.pulumi.aws.opensearch.inputs.GetServerlessCollectionPlainArgs> {
    override fun toJava(): com.pulumi.aws.opensearch.inputs.GetServerlessCollectionPlainArgs =
        com.pulumi.aws.opensearch.inputs.GetServerlessCollectionPlainArgs.builder()
            .id(id?.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServerlessCollectionPlainArgs].
 */
@PulumiTagMarker
public class GetServerlessCollectionPlainArgsBuilder internal constructor() {
    private var id: String? = null

    private var name: String? = null

    /**
     * @param value ID of the collection. Either `id` or `name` must be provided.
     */
    @JvmName("inssmdmupeimxcel")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value Name of the collection. Either `name` or `id` must be provided.
     */
    @JvmName("btyfdvjgfklfxecu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetServerlessCollectionPlainArgs = GetServerlessCollectionPlainArgs(
        id = id,
        name = name,
    )
}
