@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.inputs

import com.pulumi.aws.opensearch.inputs.GetServerlessLifecyclePolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getServerlessLifecyclePolicy.
 * @property name Name of the policy
 * @property type Type of lifecycle policy. Must be `retention`.
 */
public data class GetServerlessLifecyclePolicyPlainArgs(
    public val name: String,
    public val type: String,
) : ConvertibleToJava<com.pulumi.aws.opensearch.inputs.GetServerlessLifecyclePolicyPlainArgs> {
    override fun toJava(): com.pulumi.aws.opensearch.inputs.GetServerlessLifecyclePolicyPlainArgs =
        com.pulumi.aws.opensearch.inputs.GetServerlessLifecyclePolicyPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .type(type.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServerlessLifecyclePolicyPlainArgs].
 */
@PulumiTagMarker
public class GetServerlessLifecyclePolicyPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var type: String? = null

    /**
     * @param value Name of the policy
     */
    @JvmName("chlkofdaacjcfhvd")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Type of lifecycle policy. Must be `retention`.
     */
    @JvmName("fvuewqejsfivveet")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.type = mapped
    }

    internal fun build(): GetServerlessLifecyclePolicyPlainArgs =
        GetServerlessLifecyclePolicyPlainArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
