@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.inputs

import com.pulumi.aws.opensearch.inputs.GetServerlessVpcEndpointPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getServerlessVpcEndpoint.
 * @property vpcEndpointId The unique identifier of the endpoint.
 */
public data class GetServerlessVpcEndpointPlainArgs(
    public val vpcEndpointId: String,
) : ConvertibleToJava<com.pulumi.aws.opensearch.inputs.GetServerlessVpcEndpointPlainArgs> {
    override fun toJava(): com.pulumi.aws.opensearch.inputs.GetServerlessVpcEndpointPlainArgs =
        com.pulumi.aws.opensearch.inputs.GetServerlessVpcEndpointPlainArgs.builder()
            .vpcEndpointId(vpcEndpointId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServerlessVpcEndpointPlainArgs].
 */
@PulumiTagMarker
public class GetServerlessVpcEndpointPlainArgsBuilder internal constructor() {
    private var vpcEndpointId: String? = null

    /**
     * @param value The unique identifier of the endpoint.
     */
    @JvmName("gohxoklrxfwadygy")
    public suspend fun vpcEndpointId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vpcEndpointId = mapped
    }

    internal fun build(): GetServerlessVpcEndpointPlainArgs = GetServerlessVpcEndpointPlainArgs(
        vpcEndpointId = vpcEndpointId ?: throw PulumiNullFieldException("vpcEndpointId"),
    )
}
