@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.inputs

import com.pulumi.aws.opensearch.inputs.OutboundConnectionConnectionPropertiesCrossClusterSearchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property skipUnavailable Skips unavailable clusters and can only be used for cross-cluster searches. Accepted values are `ENABLED` or `DISABLED`.
 */
public data class OutboundConnectionConnectionPropertiesCrossClusterSearchArgs(
    public val skipUnavailable: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.opensearch.inputs.OutboundConnectionConnectionPropertiesCrossClusterSearchArgs> {
    override fun toJava(): com.pulumi.aws.opensearch.inputs.OutboundConnectionConnectionPropertiesCrossClusterSearchArgs =
        com.pulumi.aws.opensearch.inputs.OutboundConnectionConnectionPropertiesCrossClusterSearchArgs.builder()
            .skipUnavailable(skipUnavailable?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OutboundConnectionConnectionPropertiesCrossClusterSearchArgs].
 */
@PulumiTagMarker
public class OutboundConnectionConnectionPropertiesCrossClusterSearchArgsBuilder internal constructor() {
    private var skipUnavailable: Output<String>? = null

    /**
     * @param value Skips unavailable clusters and can only be used for cross-cluster searches. Accepted values are `ENABLED` or `DISABLED`.
     */
    @JvmName("wysfqmdskthdpbdd")
    public suspend fun skipUnavailable(`value`: Output<String>) {
        this.skipUnavailable = value
    }

    /**
     * @param value Skips unavailable clusters and can only be used for cross-cluster searches. Accepted values are `ENABLED` or `DISABLED`.
     */
    @JvmName("nhmtglpqgsopkicj")
    public suspend fun skipUnavailable(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipUnavailable = mapped
    }

    internal fun build(): OutboundConnectionConnectionPropertiesCrossClusterSearchArgs =
        OutboundConnectionConnectionPropertiesCrossClusterSearchArgs(
            skipUnavailable = skipUnavailable,
        )
}
