@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.inputs

import com.pulumi.aws.opensearch.inputs.OutboundConnectionRemoteDomainInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property domainName The name of the remote domain.
 * @property ownerId The Account ID of the owner of the remote domain.
 * @property region The region of the remote domain.
 */
public data class OutboundConnectionRemoteDomainInfoArgs(
    public val domainName: Output<String>,
    public val ownerId: Output<String>,
    public val region: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.opensearch.inputs.OutboundConnectionRemoteDomainInfoArgs> {
    override fun toJava(): com.pulumi.aws.opensearch.inputs.OutboundConnectionRemoteDomainInfoArgs =
        com.pulumi.aws.opensearch.inputs.OutboundConnectionRemoteDomainInfoArgs.builder()
            .domainName(domainName.applyValue({ args0 -> args0 }))
            .ownerId(ownerId.applyValue({ args0 -> args0 }))
            .region(region.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OutboundConnectionRemoteDomainInfoArgs].
 */
@PulumiTagMarker
public class OutboundConnectionRemoteDomainInfoArgsBuilder internal constructor() {
    private var domainName: Output<String>? = null

    private var ownerId: Output<String>? = null

    private var region: Output<String>? = null

    /**
     * @param value The name of the remote domain.
     */
    @JvmName("xwgniqkoqraexjgh")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value The Account ID of the owner of the remote domain.
     */
    @JvmName("jrwwsjvdwkhqjeee")
    public suspend fun ownerId(`value`: Output<String>) {
        this.ownerId = value
    }

    /**
     * @param value The region of the remote domain.
     */
    @JvmName("opsmdaoatojpyqik")
    public suspend fun region(`value`: Output<String>) {
        this.region = value
    }

    /**
     * @param value The name of the remote domain.
     */
    @JvmName("euyewtsvutuovkfc")
    public suspend fun domainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value The Account ID of the owner of the remote domain.
     */
    @JvmName("jsprlyjwlrwynbmo")
    public suspend fun ownerId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ownerId = mapped
    }

    /**
     * @param value The region of the remote domain.
     */
    @JvmName("pwlqgaoqovtoyomw")
    public suspend fun region(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.region = mapped
    }

    internal fun build(): OutboundConnectionRemoteDomainInfoArgs =
        OutboundConnectionRemoteDomainInfoArgs(
            domainName = domainName ?: throw PulumiNullFieldException("domainName"),
            ownerId = ownerId ?: throw PulumiNullFieldException("ownerId"),
            region = region ?: throw PulumiNullFieldException("region"),
        )
}
