@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.inputs

import com.pulumi.aws.opensearch.inputs.ServerlessSecurityConfigSamlOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property groupAttribute Group attribute for this SAML integration.
 * @property metadata The XML IdP metadata file generated from your identity provider.
 * @property sessionTimeout Session timeout, in minutes. Minimum is 5 minutes and maximum is 720 minutes (12 hours). Default is 60 minutes.
 * @property userAttribute User attribute for this SAML integration.
 */
public data class ServerlessSecurityConfigSamlOptionsArgs(
    public val groupAttribute: Output<String>? = null,
    public val metadata: Output<String>,
    public val sessionTimeout: Output<Int>? = null,
    public val userAttribute: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.opensearch.inputs.ServerlessSecurityConfigSamlOptionsArgs> {
    override fun toJava(): com.pulumi.aws.opensearch.inputs.ServerlessSecurityConfigSamlOptionsArgs =
        com.pulumi.aws.opensearch.inputs.ServerlessSecurityConfigSamlOptionsArgs.builder()
            .groupAttribute(groupAttribute?.applyValue({ args0 -> args0 }))
            .metadata(metadata.applyValue({ args0 -> args0 }))
            .sessionTimeout(sessionTimeout?.applyValue({ args0 -> args0 }))
            .userAttribute(userAttribute?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerlessSecurityConfigSamlOptionsArgs].
 */
@PulumiTagMarker
public class ServerlessSecurityConfigSamlOptionsArgsBuilder internal constructor() {
    private var groupAttribute: Output<String>? = null

    private var metadata: Output<String>? = null

    private var sessionTimeout: Output<Int>? = null

    private var userAttribute: Output<String>? = null

    /**
     * @param value Group attribute for this SAML integration.
     */
    @JvmName("sadedgimggnuijlm")
    public suspend fun groupAttribute(`value`: Output<String>) {
        this.groupAttribute = value
    }

    /**
     * @param value The XML IdP metadata file generated from your identity provider.
     */
    @JvmName("lanalknugbqfvlbd")
    public suspend fun metadata(`value`: Output<String>) {
        this.metadata = value
    }

    /**
     * @param value Session timeout, in minutes. Minimum is 5 minutes and maximum is 720 minutes (12 hours). Default is 60 minutes.
     */
    @JvmName("mjgbpwldaidlgcps")
    public suspend fun sessionTimeout(`value`: Output<Int>) {
        this.sessionTimeout = value
    }

    /**
     * @param value User attribute for this SAML integration.
     */
    @JvmName("wkkablqdjubnqkya")
    public suspend fun userAttribute(`value`: Output<String>) {
        this.userAttribute = value
    }

    /**
     * @param value Group attribute for this SAML integration.
     */
    @JvmName("mnsalmobamfhxkvg")
    public suspend fun groupAttribute(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupAttribute = mapped
    }

    /**
     * @param value The XML IdP metadata file generated from your identity provider.
     */
    @JvmName("ovmcdrrxuyguhpks")
    public suspend fun metadata(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value Session timeout, in minutes. Minimum is 5 minutes and maximum is 720 minutes (12 hours). Default is 60 minutes.
     */
    @JvmName("wtykywgjbttxyhje")
    public suspend fun sessionTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionTimeout = mapped
    }

    /**
     * @param value User attribute for this SAML integration.
     */
    @JvmName("pcmkgetvblapvyen")
    public suspend fun userAttribute(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAttribute = mapped
    }

    internal fun build(): ServerlessSecurityConfigSamlOptionsArgs =
        ServerlessSecurityConfigSamlOptionsArgs(
            groupAttribute = groupAttribute,
            metadata = metadata ?: throw PulumiNullFieldException("metadata"),
            sessionTimeout = sessionTimeout,
            userAttribute = userAttribute,
        )
}
