@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property anonymousAuthEnabled Whether Anonymous auth is enabled. Enables fine-grained access control on an existing domain. Ignored unless `advanced_security_options` are enabled. _Can only be enabled on an existing domain._
 * @property enabled Whether advanced security is enabled.
 * @property internalUserDatabaseEnabled Whether the internal user database is enabled. Default is `false`.
 * @property masterUserOptions Configuration block for the main user. Detailed below.
 */
public data class DomainAdvancedSecurityOptions(
    public val anonymousAuthEnabled: Boolean? = null,
    public val enabled: Boolean,
    public val internalUserDatabaseEnabled: Boolean? = null,
    public val masterUserOptions: DomainAdvancedSecurityOptionsMasterUserOptions? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.opensearch.outputs.DomainAdvancedSecurityOptions): DomainAdvancedSecurityOptions = DomainAdvancedSecurityOptions(
            anonymousAuthEnabled = javaType.anonymousAuthEnabled().map({ args0 -> args0 }).orElse(null),
            enabled = javaType.enabled(),
            internalUserDatabaseEnabled = javaType.internalUserDatabaseEnabled().map({ args0 ->
                args0
            }).orElse(null),
            masterUserOptions = javaType.masterUserOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.opensearch.kotlin.outputs.DomainAdvancedSecurityOptionsMasterUserOptions.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
