@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property desiredState Auto-Tune desired state for the domain. Valid values: `ENABLED` or `DISABLED`.
 * @property maintenanceSchedules Configuration block for Auto-Tune maintenance windows. Can be specified multiple times for each maintenance window. Detailed below.
 * **NOTE:** Maintenance windows are deprecated and have been replaced with [off-peak windows](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/off-peak.html). Consequently, `maintenance_schedule` configuration blocks cannot be specified when `use_off_peak_window` is set to `true`.
 * @property rollbackOnDisable Whether to roll back to default Auto-Tune settings when disabling Auto-Tune. Valid values: `DEFAULT_ROLLBACK` or `NO_ROLLBACK`.
 * @property useOffPeakWindow Whether to schedule Auto-Tune optimizations that require blue/green deployments during the domain's configured daily off-peak window. Defaults to `false`.
 */
public data class DomainAutoTuneOptions(
    public val desiredState: String,
    public val maintenanceSchedules: List<DomainAutoTuneOptionsMaintenanceSchedule>? = null,
    public val rollbackOnDisable: String? = null,
    public val useOffPeakWindow: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.opensearch.outputs.DomainAutoTuneOptions): DomainAutoTuneOptions = DomainAutoTuneOptions(
            desiredState = javaType.desiredState(),
            maintenanceSchedules = javaType.maintenanceSchedules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.opensearch.kotlin.outputs.DomainAutoTuneOptionsMaintenanceSchedule.Companion.toKotlin(args0)
                })
            }),
            rollbackOnDisable = javaType.rollbackOnDisable().map({ args0 -> args0 }).orElse(null),
            useOffPeakWindow = javaType.useOffPeakWindow().map({ args0 -> args0 }).orElse(null),
        )
    }
}
