@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property enabled Boolean to enable cold storage for an OpenSearch domain. Defaults to `false`. Master and ultrawarm nodes must be enabled for cold storage.
 */
public data class DomainClusterConfigColdStorageOptions(
    public val enabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.opensearch.outputs.DomainClusterConfigColdStorageOptions): DomainClusterConfigColdStorageOptions = DomainClusterConfigColdStorageOptions(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
