@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property availabilityZones If the domain was created inside a VPC, the names of the availability zones the configured `subnet_ids` were created inside.
 * @property securityGroupIds List of VPC Security Group IDs to be applied to the OpenSearch domain endpoints. If omitted, the default Security Group for the VPC will be used.
 * @property subnetIds List of VPC Subnet IDs for the OpenSearch domain endpoints to be created in.
 * @property vpcId If the domain was created inside a VPC, the ID of the VPC.
 */
public data class DomainVpcOptions(
    public val availabilityZones: List<String>? = null,
    public val securityGroupIds: List<String>? = null,
    public val subnetIds: List<String>? = null,
    public val vpcId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.opensearch.outputs.DomainVpcOptions): DomainVpcOptions = DomainVpcOptions(
            availabilityZones = javaType.availabilityZones().map({ args0 -> args0 }),
            securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
            subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
            vpcId = javaType.vpcId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
