@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property anonymousAuthEnabled
 * @property enabled Enabled disabled toggle for off-peak update window
 * @property internalUserDatabaseEnabled Whether the internal user database is enabled.
 */
public data class GetDomainAdvancedSecurityOption(
    public val anonymousAuthEnabled: Boolean,
    public val enabled: Boolean,
    public val internalUserDatabaseEnabled: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.opensearch.outputs.GetDomainAdvancedSecurityOption): GetDomainAdvancedSecurityOption = GetDomainAdvancedSecurityOption(
            anonymousAuthEnabled = javaType.anonymousAuthEnabled(),
            enabled = javaType.enabled(),
            internalUserDatabaseEnabled = javaType.internalUserDatabaseEnabled(),
        )
    }
}
