@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property ebsEnabled Whether EBS volumes are attached to data nodes in the domain.
 * @property iops Baseline input/output (I/O) performance of EBS volumes attached to data nodes.
 * @property throughput The throughput (in MiB/s) of the EBS volumes attached to data nodes.
 * @property volumeSize Size of EBS volumes attached to data nodes (in GB).
 * @property volumeType Type of EBS volumes attached to data nodes.
 */
public data class GetDomainEbsOption(
    public val ebsEnabled: Boolean,
    public val iops: Int,
    public val throughput: Int,
    public val volumeSize: Int,
    public val volumeType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.opensearch.outputs.GetDomainEbsOption): GetDomainEbsOption = GetDomainEbsOption(
            ebsEnabled = javaType.ebsEnabled(),
            iops = javaType.iops(),
            throughput = javaType.throughput(),
            volumeSize = javaType.volumeSize(),
            volumeType = javaType.volumeType(),
        )
    }
}
