@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cloudwatchLogGroupArn CloudWatch Log Group where the logs are published.
 * @property enabled Enabled disabled toggle for off-peak update window
 * @property logType Type of OpenSearch log being published.
 */
public data class GetDomainLogPublishingOption(
    public val cloudwatchLogGroupArn: String,
    public val enabled: Boolean,
    public val logType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.opensearch.outputs.GetDomainLogPublishingOption): GetDomainLogPublishingOption = GetDomainLogPublishingOption(
            cloudwatchLogGroupArn = javaType.cloudwatchLogGroupArn(),
            enabled = javaType.enabled(),
            logType = javaType.logType(),
        )
    }
}
