@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.outputs

import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getDomain.
 * @property accessPolicies Policy document attached to the domain.
 * @property advancedOptions Key-value string pairs to specify advanced configuration options.
 * @property advancedSecurityOptions Status of the OpenSearch domain's advanced security options. The block consists of the following attributes:
 * @property arn ARN of the domain.
 * @property autoTuneOptions Configuration of the Auto-Tune options of the domain.
 * @property clusterConfigs Cluster configuration of the domain.
 * @property cognitoOptions Domain Amazon Cognito Authentication options for Dashboard.
 * @property created Status of the creation of the domain.
 * @property dashboardEndpoint Domain-specific endpoint used to access the [Dashboard application](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/dashboards.html).
 * @property deleted Status of the deletion of the domain.
 * @property domainId Unique identifier for the domain.
 * @property domainName
 * @property ebsOptions EBS Options for the instances in the domain.
 * @property encryptionAtRests Domain encryption at rest related options.
 * @property endpoint Domain-specific endpoint used to submit index, search, and data upload requests.
 * @property engineVersion OpenSearch version for the domain.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ipAddressType Type of IP addresses supported by the endpoint for the domain.
 * @property kibanaEndpoint (**Deprecated**) Domain-specific endpoint for kibana without https scheme. Use the `dashboard_endpoint` attribute instead.
 * @property logPublishingOptions Domain log publishing related options.
 * @property nodeToNodeEncryptions Domain in transit encryption related options.
 * @property offPeakWindowOptions Off Peak update options
 * @property processing Status of a configuration change in the domain.
 * @property snapshotOptions Domain snapshot related options.
 * @property softwareUpdateOptions Software update options for the domain
 * @property tags Tags assigned to the domain.
 * @property vpcOptions VPC Options for private OpenSearch domains.
 */
public data class GetDomainResult(
    public val accessPolicies: String,
    public val advancedOptions: Map<String, String>,
    public val advancedSecurityOptions: List<GetDomainAdvancedSecurityOption>,
    public val arn: String,
    public val autoTuneOptions: List<GetDomainAutoTuneOption>,
    public val clusterConfigs: List<GetDomainClusterConfig>,
    public val cognitoOptions: List<GetDomainCognitoOption>,
    public val created: Boolean,
    public val dashboardEndpoint: String,
    public val deleted: Boolean,
    public val domainId: String,
    public val domainName: String,
    public val ebsOptions: List<GetDomainEbsOption>,
    public val encryptionAtRests: List<GetDomainEncryptionAtRest>,
    public val endpoint: String,
    public val engineVersion: String,
    public val id: String,
    public val ipAddressType: String,
    @Deprecated(
        message = """
  use 'dashboard_endpoint' attribute instead
  """,
    )
    public val kibanaEndpoint: String,
    public val logPublishingOptions: List<GetDomainLogPublishingOption>,
    public val nodeToNodeEncryptions: List<GetDomainNodeToNodeEncryption>,
    public val offPeakWindowOptions: GetDomainOffPeakWindowOptions? = null,
    public val processing: Boolean,
    public val snapshotOptions: List<GetDomainSnapshotOption>,
    public val softwareUpdateOptions: List<GetDomainSoftwareUpdateOption>,
    public val tags: Map<String, String>,
    public val vpcOptions: List<GetDomainVpcOption>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.opensearch.outputs.GetDomainResult): GetDomainResult = GetDomainResult(
            accessPolicies = javaType.accessPolicies(),
            advancedOptions = javaType.advancedOptions().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            advancedSecurityOptions = javaType.advancedSecurityOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.opensearch.kotlin.outputs.GetDomainAdvancedSecurityOption.Companion.toKotlin(args0)
                })
            }),
            arn = javaType.arn(),
            autoTuneOptions = javaType.autoTuneOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.opensearch.kotlin.outputs.GetDomainAutoTuneOption.Companion.toKotlin(args0)
                })
            }),
            clusterConfigs = javaType.clusterConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.opensearch.kotlin.outputs.GetDomainClusterConfig.Companion.toKotlin(args0)
                })
            }),
            cognitoOptions = javaType.cognitoOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.opensearch.kotlin.outputs.GetDomainCognitoOption.Companion.toKotlin(args0)
                })
            }),
            created = javaType.created(),
            dashboardEndpoint = javaType.dashboardEndpoint(),
            deleted = javaType.deleted(),
            domainId = javaType.domainId(),
            domainName = javaType.domainName(),
            ebsOptions = javaType.ebsOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.opensearch.kotlin.outputs.GetDomainEbsOption.Companion.toKotlin(args0)
                })
            }),
            encryptionAtRests = javaType.encryptionAtRests().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.opensearch.kotlin.outputs.GetDomainEncryptionAtRest.Companion.toKotlin(args0)
                })
            }),
            endpoint = javaType.endpoint(),
            engineVersion = javaType.engineVersion(),
            id = javaType.id(),
            ipAddressType = javaType.ipAddressType(),
            kibanaEndpoint = javaType.kibanaEndpoint(),
            logPublishingOptions = javaType.logPublishingOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.opensearch.kotlin.outputs.GetDomainLogPublishingOption.Companion.toKotlin(args0)
                })
            }),
            nodeToNodeEncryptions = javaType.nodeToNodeEncryptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.opensearch.kotlin.outputs.GetDomainNodeToNodeEncryption.Companion.toKotlin(args0)
                })
            }),
            offPeakWindowOptions = javaType.offPeakWindowOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.opensearch.kotlin.outputs.GetDomainOffPeakWindowOptions.Companion.toKotlin(args0)
                })
            }).orElse(null),
            processing = javaType.processing(),
            snapshotOptions = javaType.snapshotOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.opensearch.kotlin.outputs.GetDomainSnapshotOption.Companion.toKotlin(args0)
                })
            }),
            softwareUpdateOptions = javaType.softwareUpdateOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.opensearch.kotlin.outputs.GetDomainSoftwareUpdateOption.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vpcOptions = javaType.vpcOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.opensearch.kotlin.outputs.GetDomainVpcOption.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
