@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getServerlessLifecyclePolicy.
 * @property createdDate The date the lifecycle policy was created.
 * @property description Description of the policy. Typically used to store information about the permissions defined in the policy.
 * @property id
 * @property lastModifiedDate The date the lifecycle policy was last modified.
 * @property name
 * @property policy JSON policy document to use as the content for the new policy.
 * @property policyVersion Version of the policy.
 * @property type
 */
public data class GetServerlessLifecyclePolicyResult(
    public val createdDate: String,
    public val description: String,
    public val id: String,
    public val lastModifiedDate: String,
    public val name: String,
    public val policy: String,
    public val policyVersion: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.opensearch.outputs.GetServerlessLifecyclePolicyResult): GetServerlessLifecyclePolicyResult = GetServerlessLifecyclePolicyResult(
            createdDate = javaType.createdDate(),
            description = javaType.description(),
            id = javaType.id(),
            lastModifiedDate = javaType.lastModifiedDate(),
            name = javaType.name(),
            policy = javaType.policy(),
            policyVersion = javaType.policyVersion(),
            type = javaType.type(),
        )
    }
}
