@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property domainName The name of the remote domain.
 * @property ownerId The Account ID of the owner of the remote domain.
 * @property region The region of the remote domain.
 */
public data class OutboundConnectionRemoteDomainInfo(
    public val domainName: String,
    public val ownerId: String,
    public val region: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.opensearch.outputs.OutboundConnectionRemoteDomainInfo): OutboundConnectionRemoteDomainInfo = OutboundConnectionRemoteDomainInfo(
            domainName = javaType.domainName(),
            ownerId = javaType.ownerId(),
            region = javaType.region(),
        )
    }
}
