@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property s3BucketName The name of the Amazon S3 bucket containing the package.
 * @property s3Key Key (file name) of the package.
 */
public data class PackagePackageSource(
    public val s3BucketName: String,
    public val s3Key: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.opensearch.outputs.PackagePackageSource): PackagePackageSource = PackagePackageSource(
            s3BucketName = javaType.s3BucketName(),
            s3Key = javaType.s3Key(),
        )
    }
}
