@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property groupAttribute Group attribute for this SAML integration.
 * @property metadata The XML IdP metadata file generated from your identity provider.
 * @property sessionTimeout Session timeout, in minutes. Minimum is 5 minutes and maximum is 720 minutes (12 hours). Default is 60 minutes.
 * @property userAttribute User attribute for this SAML integration.
 */
public data class ServerlessSecurityConfigSamlOptions(
    public val groupAttribute: String? = null,
    public val metadata: String,
    public val sessionTimeout: Int? = null,
    public val userAttribute: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.opensearch.outputs.ServerlessSecurityConfigSamlOptions): ServerlessSecurityConfigSamlOptions = ServerlessSecurityConfigSamlOptions(
            groupAttribute = javaType.groupAttribute().map({ args0 -> args0 }).orElse(null),
            metadata = javaType.metadata(),
            sessionTimeout = javaType.sessionTimeout().map({ args0 -> args0 }).orElse(null),
            userAttribute = javaType.userAttribute().map({ args0 -> args0 }).orElse(null),
        )
    }
}
