@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearchingest.kotlin

import com.pulumi.aws.opensearchingest.kotlin.outputs.PipelineBufferOptions
import com.pulumi.aws.opensearchingest.kotlin.outputs.PipelineEncryptionAtRestOptions
import com.pulumi.aws.opensearchingest.kotlin.outputs.PipelineLogPublishingOptions
import com.pulumi.aws.opensearchingest.kotlin.outputs.PipelineTimeouts
import com.pulumi.aws.opensearchingest.kotlin.outputs.PipelineVpcOptions
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.opensearchingest.kotlin.outputs.PipelineBufferOptions.Companion.toKotlin as pipelineBufferOptionsToKotlin
import com.pulumi.aws.opensearchingest.kotlin.outputs.PipelineEncryptionAtRestOptions.Companion.toKotlin as pipelineEncryptionAtRestOptionsToKotlin
import com.pulumi.aws.opensearchingest.kotlin.outputs.PipelineLogPublishingOptions.Companion.toKotlin as pipelineLogPublishingOptionsToKotlin
import com.pulumi.aws.opensearchingest.kotlin.outputs.PipelineTimeouts.Companion.toKotlin as pipelineTimeoutsToKotlin
import com.pulumi.aws.opensearchingest.kotlin.outputs.PipelineVpcOptions.Companion.toKotlin as pipelineVpcOptionsToKotlin

/**
 * Builder for [Pipeline].
 */
@PulumiTagMarker
public class PipelineResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PipelineArgs = PipelineArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PipelineArgsBuilder.() -> Unit) {
        val builder = PipelineArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Pipeline {
        val builtJavaResource = com.pulumi.aws.opensearchingest.Pipeline(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Pipeline(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS OpenSearch Ingestion Pipeline.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.getRegion({});
 * const example = new aws.iam.Role("example", {assumeRolePolicy: JSON.stringify({
 *     Version: "2012-10-17",
 *     Statement: [{
 *         Action: "sts:AssumeRole",
 *         Effect: "Allow",
 *         Sid: "",
 *         Principal: {
 *             Service: "osis-pipelines.amazonaws.com",
 *         },
 *     }],
 * })});
 * const examplePipeline = new aws.opensearchingest.Pipeline("example", {
 *     pipelineName: "example",
 *     pipelineConfigurationBody: pulumi.all([example&#46;arn, current])&#46;apply(([arn, current]) => `version: "2"
 * example-pipeline:
 *   source:
 *     http:
 *       path: "/example"
 *   sink:
 *     - s3:
 *         aws:
 *           sts_role_arn: "${arn}"
 *           region: "${current.name}"
 *         bucket: "example"
 *         threshold:
 *           event_collect_timeout: "60s"
 *         codec:
 *           ndjson:
 * `),
 *     maxUnits: 1,
 *     minUnits: 1,
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * current = aws.get_region()
 * example = aws.iam.Role("example", assume_role_policy=json.dumps({
 *     "Version": "2012-10-17",
 *     "Statement": [{
 *         "Action": "sts:AssumeRole",
 *         "Effect": "Allow",
 *         "Sid": "",
 *         "Principal": {
 *             "Service": "osis-pipelines.amazonaws.com",
 *         },
 *     }],
 * }))
 * example_pipeline = aws.opensearchingest.Pipeline("example",
 *     pipeline_name="example",
 *     pipeline_configuration_body=example.arn.apply(lambda arn: f"""version: "2"
 * example-pipeline:
 *   source:
 *     http:
 *       path: "/example"
 *   sink:
 *     - s3:
 *         aws:
 *           sts_role_arn: "{arn}"
 *           region: "{current.name}"
 *         bucket: "example"
 *         threshold:
 *           event_collect_timeout: "60s"
 *         codec:
 *           ndjson:
 * """),
 *     max_units=1,
 *     min_units=1)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.GetRegion.Invoke();
 *     var example = new Aws.Iam.Role("example", new()
 *     {
 *         AssumeRolePolicy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2012-10-17",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Action"] = "sts:AssumeRole",
 *                     ["Effect"] = "Allow",
 *                     ["Sid"] = "",
 *                     ["Principal"] = new Dictionary<string, object?>
 *                     {
 *                         ["Service"] = "osis-pipelines.amazonaws.com",
 *                     },
 *                 },
 *             },
 *         }),
 *     });
 *     var examplePipeline = new Aws.OpenSearchIngest.Pipeline("example", new()
 *     {
 *         PipelineName = "example",
 *         PipelineConfigurationBody = Output.Tuple(example.Arn, current).Apply(values =>
 *         {
 *             var arn = values.Item1;
 *             var current = values.Item2;
 *             return @$"version: ""2""
 * example-pipeline:
 *   source:
 *     http:
 *       path: ""/example""
 *   sink:
 *     - s3:
 *         aws:
 *           sts_role_arn: ""{arn}""
 *           region: ""{current.Apply(getRegionResult => getRegionResult.Name)}""
 *         bucket: ""example""
 *         threshold:
 *           event_collect_timeout: ""60s""
 *         codec:
 *           ndjson:
 * ";
 *         }),
 *         MaxUnits = 1,
 *         MinUnits = 1,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/opensearchingest"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		current, err := aws.GetRegion(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Action": "sts:AssumeRole",
 * 					"Effect": "Allow",
 * 					"Sid":    "",
 * 					"Principal": map[string]interface{}{
 * 						"Service": "osis-pipelines.amazonaws.com",
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		example, err := iam.NewRole(ctx, "example", &iam.RoleArgs{
 * 			AssumeRolePolicy: pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = opensearchingest.NewPipeline(ctx, "example", &opensearchingest.PipelineArgs{
 * 			PipelineName: pulumi.String("example"),
 * 			PipelineConfigurationBody: example.Arn.ApplyT(func(arn string) (string, error) {
 * 				return fmt.Sprintf(`version: "2"
 * example-pipeline:
 *   source:
 *     http:
 *       path: "/example"
 *   sink:
 *     - s3:
 *         aws:
 *           sts_role_arn: "%v"
 *           region: "%v"
 *         bucket: "example"
 *         threshold:
 *           event_collect_timeout: "60s"
 *         codec:
 *           ndjson:
 * `, arn, current.Name), nil
 * 			}).(pulumi.StringOutput),
 * 			MaxUnits: pulumi.Int(1),
 * 			MinUnits: pulumi.Int(1),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.opensearchingest.Pipeline;
 * import com.pulumi.aws.opensearchingest.PipelineArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getRegion();
 *         var example = new Role("example", RoleArgs.builder()
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", "sts:AssumeRole"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Sid", ""),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "osis-pipelines.amazonaws.com")
 *                         ))
 *                     )))
 *                 )))
 *             .build());
 *         var examplePipeline = new Pipeline("examplePipeline", PipelineArgs.builder()
 *             .pipelineName("example")
 *             .pipelineConfigurationBody(example.arn().applyValue(arn -> """
 * version: "2"
 * example-pipeline:
 *   source:
 *     http:
 *       path: "/example"
 *   sink:
 *     - s3:
 *         aws:
 *           sts_role_arn: "%s"
 *           region: "%s"
 *         bucket: "example"
 *         threshold:
 *           event_collect_timeout: "60s"
 *         codec:
 *           ndjson:
 * ", arn,current.applyValue(getRegionResult -> getRegionResult.name()))))
 *             .maxUnits(1)
 *             .minUnits(1)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:iam:Role
 *     properties:
 *       assumeRolePolicy:
 *         fn::toJSON:
 *           Version: 2012-10-17
 *           Statement:
 *             - Action: sts:AssumeRole
 *               Effect: Allow
 *               Sid:
 *               Principal:
 *                 Service: osis-pipelines.amazonaws.com
 *   examplePipeline:
 *     type: aws:opensearchingest:Pipeline
 *     name: example
 *     properties:
 *       pipelineName: example
 *       pipelineConfigurationBody: |
 *         version: "2"
 *         example-pipeline:
 *           source:
 *             http:
 *               path: "/example"
 *           sink:
 *             - s3:
 *                 aws:
 *                   sts_role_arn: "${example.arn}"
 *                   region: "${current.name}"
 *                 bucket: "example"
 *                 threshold:
 *                   event_collect_timeout: "60s"
 *                 codec:
 *                   ndjson:
 *       maxUnits: 1
 *       minUnits: 1
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getRegion
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Using file function
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const example = new aws.opensearchingest.Pipeline("example", {
 *     pipelineName: "example",
 *     pipelineConfigurationBody: std.file({
 *         input: "example.yaml",
 *     }).then(invoke => invoke.result),
 *     maxUnits: 1,
 *     minUnits: 1,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * example = aws.opensearchingest.Pipeline("example",
 *     pipeline_name="example",
 *     pipeline_configuration_body=std.file(input="example.yaml").result,
 *     max_units=1,
 *     min_units=1)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.OpenSearchIngest.Pipeline("example", new()
 *     {
 *         PipelineName = "example",
 *         PipelineConfigurationBody = Std.File.Invoke(new()
 *         {
 *             Input = "example.yaml",
 *         }).Apply(invoke => invoke.Result),
 *         MaxUnits = 1,
 *         MinUnits = 1,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/opensearchingest"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		invokeFile, err := std.File(ctx, &std.FileArgs{
 * 			Input: "example.yaml",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = opensearchingest.NewPipeline(ctx, "example", &opensearchingest.PipelineArgs{
 * 			PipelineName:              pulumi.String("example"),
 * 			PipelineConfigurationBody: pulumi.String(invokeFile.Result),
 * 			MaxUnits:                  pulumi.Int(1),
 * 			MinUnits:                  pulumi.Int(1),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearchingest.Pipeline;
 * import com.pulumi.aws.opensearchingest.PipelineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Pipeline("example", PipelineArgs.builder()
 *             .pipelineName("example")
 *             .pipelineConfigurationBody(StdFunctions.file(FileArgs.builder()
 *                 .input("example.yaml")
 *                 .build()).result())
 *             .maxUnits(1)
 *             .minUnits(1)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:opensearchingest:Pipeline
 *     properties:
 *       pipelineName: example
 *       pipelineConfigurationBody:
 *         fn::invoke:
 *           Function: std:file
 *           Arguments:
 *             input: example.yaml
 *           Return: result
 *       maxUnits: 1
 *       minUnits: 1
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import OpenSearch Ingestion Pipeline using the `id`. For example:
 * ```sh
 * $ pulumi import aws:opensearchingest/pipeline:Pipeline example example
 * ```
 */
public class Pipeline internal constructor(
    override val javaResource: com.pulumi.aws.opensearchingest.Pipeline,
) : KotlinCustomResource(javaResource, PipelineMapper) {
    /**
     * Key-value pairs to configure persistent buffering for the pipeline. See `buffer_options` below.
     */
    public val bufferOptions: Output<PipelineBufferOptions>?
        get() = javaResource.bufferOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> pipelineBufferOptionsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Key-value pairs to configure encryption for data that is written to a persistent buffer. See `encryption_at_rest_options` below.
     */
    public val encryptionAtRestOptions: Output<PipelineEncryptionAtRestOptions>?
        get() = javaResource.encryptionAtRestOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> pipelineEncryptionAtRestOptionsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The list of ingestion endpoints for the pipeline, which you can send data to.
     */
    public val ingestEndpointUrls: Output<List<String>>
        get() = javaResource.ingestEndpointUrls().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Key-value pairs to configure log publishing. See `log_publishing_options` below.
     */
    public val logPublishingOptions: Output<PipelineLogPublishingOptions>?
        get() = javaResource.logPublishingOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> pipelineLogPublishingOptionsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The maximum pipeline capacity, in Ingestion Compute Units (ICUs).
     */
    public val maxUnits: Output<Int>
        get() = javaResource.maxUnits().applyValue({ args0 -> args0 })

    /**
     * The minimum pipeline capacity, in Ingestion Compute Units (ICUs).
     */
    public val minUnits: Output<Int>
        get() = javaResource.minUnits().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the pipeline.
     */
    public val pipelineArn: Output<String>
        get() = javaResource.pipelineArn().applyValue({ args0 -> args0 })

    /**
     * The pipeline configuration in YAML format. This argument accepts the pipeline configuration as a string or within a .yaml file. If you provide the configuration as a string, each new line must be escaped with \n.
     */
    public val pipelineConfigurationBody: Output<String>
        get() = javaResource.pipelineConfigurationBody().applyValue({ args0 -> args0 })

    /**
     * The name of the OpenSearch Ingestion pipeline to create. Pipeline names are unique across the pipelines owned by an account within an AWS Region.
     * The following arguments are optional:
     */
    public val pipelineName: Output<String>
        get() = javaResource.pipelineName().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the pipeline. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val timeouts: Output<PipelineTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    pipelineTimeoutsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Container for the values required to configure VPC access for the pipeline. If you don't specify these values, OpenSearch Ingestion creates the pipeline with a public endpoint. See `vpc_options` below.
     */
    public val vpcOptions: Output<PipelineVpcOptions>?
        get() = javaResource.vpcOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    pipelineVpcOptionsToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object PipelineMapper : ResourceMapper<Pipeline> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.opensearchingest.Pipeline::class == javaResource::class

    override fun map(javaResource: Resource): Pipeline = Pipeline(
        javaResource as
            com.pulumi.aws.opensearchingest.Pipeline,
    )
}

/**
 * @see [Pipeline].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Pipeline].
 */
public suspend fun pipeline(name: String, block: suspend PipelineResourceBuilder.() -> Unit): Pipeline {
    val builder = PipelineResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Pipeline].
 * @param name The _unique_ name of the resulting resource.
 */
public fun pipeline(name: String): Pipeline {
    val builder = PipelineResourceBuilder()
    builder.name(name)
    return builder.build()
}
