@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearchingest.kotlin

import com.pulumi.aws.opensearchingest.PipelineArgs.builder
import com.pulumi.aws.opensearchingest.kotlin.inputs.PipelineBufferOptionsArgs
import com.pulumi.aws.opensearchingest.kotlin.inputs.PipelineBufferOptionsArgsBuilder
import com.pulumi.aws.opensearchingest.kotlin.inputs.PipelineEncryptionAtRestOptionsArgs
import com.pulumi.aws.opensearchingest.kotlin.inputs.PipelineEncryptionAtRestOptionsArgsBuilder
import com.pulumi.aws.opensearchingest.kotlin.inputs.PipelineLogPublishingOptionsArgs
import com.pulumi.aws.opensearchingest.kotlin.inputs.PipelineLogPublishingOptionsArgsBuilder
import com.pulumi.aws.opensearchingest.kotlin.inputs.PipelineTimeoutsArgs
import com.pulumi.aws.opensearchingest.kotlin.inputs.PipelineTimeoutsArgsBuilder
import com.pulumi.aws.opensearchingest.kotlin.inputs.PipelineVpcOptionsArgs
import com.pulumi.aws.opensearchingest.kotlin.inputs.PipelineVpcOptionsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS OpenSearch Ingestion Pipeline.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.getRegion({});
 * const example = new aws.iam.Role("example", {assumeRolePolicy: JSON.stringify({
 *     Version: "2012-10-17",
 *     Statement: [{
 *         Action: "sts:AssumeRole",
 *         Effect: "Allow",
 *         Sid: "",
 *         Principal: {
 *             Service: "osis-pipelines.amazonaws.com",
 *         },
 *     }],
 * })});
 * const examplePipeline = new aws.opensearchingest.Pipeline("example", {
 *     pipelineName: "example",
 *     pipelineConfigurationBody: pulumi.all([example&#46;arn, current])&#46;apply(([arn, current]) => `version: "2"
 * example-pipeline:
 *   source:
 *     http:
 *       path: "/example"
 *   sink:
 *     - s3:
 *         aws:
 *           sts_role_arn: "${arn}"
 *           region: "${current.name}"
 *         bucket: "example"
 *         threshold:
 *           event_collect_timeout: "60s"
 *         codec:
 *           ndjson:
 * `),
 *     maxUnits: 1,
 *     minUnits: 1,
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * current = aws.get_region()
 * example = aws.iam.Role("example", assume_role_policy=json.dumps({
 *     "Version": "2012-10-17",
 *     "Statement": [{
 *         "Action": "sts:AssumeRole",
 *         "Effect": "Allow",
 *         "Sid": "",
 *         "Principal": {
 *             "Service": "osis-pipelines.amazonaws.com",
 *         },
 *     }],
 * }))
 * example_pipeline = aws.opensearchingest.Pipeline("example",
 *     pipeline_name="example",
 *     pipeline_configuration_body=example.arn.apply(lambda arn: f"""version: "2"
 * example-pipeline:
 *   source:
 *     http:
 *       path: "/example"
 *   sink:
 *     - s3:
 *         aws:
 *           sts_role_arn: "{arn}"
 *           region: "{current.name}"
 *         bucket: "example"
 *         threshold:
 *           event_collect_timeout: "60s"
 *         codec:
 *           ndjson:
 * """),
 *     max_units=1,
 *     min_units=1)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.GetRegion.Invoke();
 *     var example = new Aws.Iam.Role("example", new()
 *     {
 *         AssumeRolePolicy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2012-10-17",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Action"] = "sts:AssumeRole",
 *                     ["Effect"] = "Allow",
 *                     ["Sid"] = "",
 *                     ["Principal"] = new Dictionary<string, object?>
 *                     {
 *                         ["Service"] = "osis-pipelines.amazonaws.com",
 *                     },
 *                 },
 *             },
 *         }),
 *     });
 *     var examplePipeline = new Aws.OpenSearchIngest.Pipeline("example", new()
 *     {
 *         PipelineName = "example",
 *         PipelineConfigurationBody = Output.Tuple(example.Arn, current).Apply(values =>
 *         {
 *             var arn = values.Item1;
 *             var current = values.Item2;
 *             return @$"version: ""2""
 * example-pipeline:
 *   source:
 *     http:
 *       path: ""/example""
 *   sink:
 *     - s3:
 *         aws:
 *           sts_role_arn: ""{arn}""
 *           region: ""{current.Apply(getRegionResult => getRegionResult.Name)}""
 *         bucket: ""example""
 *         threshold:
 *           event_collect_timeout: ""60s""
 *         codec:
 *           ndjson:
 * ";
 *         }),
 *         MaxUnits = 1,
 *         MinUnits = 1,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/opensearchingest"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		current, err := aws.GetRegion(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Action": "sts:AssumeRole",
 * 					"Effect": "Allow",
 * 					"Sid":    "",
 * 					"Principal": map[string]interface{}{
 * 						"Service": "osis-pipelines.amazonaws.com",
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		example, err := iam.NewRole(ctx, "example", &iam.RoleArgs{
 * 			AssumeRolePolicy: pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = opensearchingest.NewPipeline(ctx, "example", &opensearchingest.PipelineArgs{
 * 			PipelineName: pulumi.String("example"),
 * 			PipelineConfigurationBody: example.Arn.ApplyT(func(arn string) (string, error) {
 * 				return fmt.Sprintf(`version: "2"
 * example-pipeline:
 *   source:
 *     http:
 *       path: "/example"
 *   sink:
 *     - s3:
 *         aws:
 *           sts_role_arn: "%v"
 *           region: "%v"
 *         bucket: "example"
 *         threshold:
 *           event_collect_timeout: "60s"
 *         codec:
 *           ndjson:
 * `, arn, current.Name), nil
 * 			}).(pulumi.StringOutput),
 * 			MaxUnits: pulumi.Int(1),
 * 			MinUnits: pulumi.Int(1),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.opensearchingest.Pipeline;
 * import com.pulumi.aws.opensearchingest.PipelineArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getRegion();
 *         var example = new Role("example", RoleArgs.builder()
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", "sts:AssumeRole"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Sid", ""),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "osis-pipelines.amazonaws.com")
 *                         ))
 *                     )))
 *                 )))
 *             .build());
 *         var examplePipeline = new Pipeline("examplePipeline", PipelineArgs.builder()
 *             .pipelineName("example")
 *             .pipelineConfigurationBody(example.arn().applyValue(arn -> """
 * version: "2"
 * example-pipeline:
 *   source:
 *     http:
 *       path: "/example"
 *   sink:
 *     - s3:
 *         aws:
 *           sts_role_arn: "%s"
 *           region: "%s"
 *         bucket: "example"
 *         threshold:
 *           event_collect_timeout: "60s"
 *         codec:
 *           ndjson:
 * ", arn,current.applyValue(getRegionResult -> getRegionResult.name()))))
 *             .maxUnits(1)
 *             .minUnits(1)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:iam:Role
 *     properties:
 *       assumeRolePolicy:
 *         fn::toJSON:
 *           Version: 2012-10-17
 *           Statement:
 *             - Action: sts:AssumeRole
 *               Effect: Allow
 *               Sid:
 *               Principal:
 *                 Service: osis-pipelines.amazonaws.com
 *   examplePipeline:
 *     type: aws:opensearchingest:Pipeline
 *     name: example
 *     properties:
 *       pipelineName: example
 *       pipelineConfigurationBody: |
 *         version: "2"
 *         example-pipeline:
 *           source:
 *             http:
 *               path: "/example"
 *           sink:
 *             - s3:
 *                 aws:
 *                   sts_role_arn: "${example.arn}"
 *                   region: "${current.name}"
 *                 bucket: "example"
 *                 threshold:
 *                   event_collect_timeout: "60s"
 *                 codec:
 *                   ndjson:
 *       maxUnits: 1
 *       minUnits: 1
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getRegion
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Using file function
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const example = new aws.opensearchingest.Pipeline("example", {
 *     pipelineName: "example",
 *     pipelineConfigurationBody: std.file({
 *         input: "example.yaml",
 *     }).then(invoke => invoke.result),
 *     maxUnits: 1,
 *     minUnits: 1,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * example = aws.opensearchingest.Pipeline("example",
 *     pipeline_name="example",
 *     pipeline_configuration_body=std.file(input="example.yaml").result,
 *     max_units=1,
 *     min_units=1)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.OpenSearchIngest.Pipeline("example", new()
 *     {
 *         PipelineName = "example",
 *         PipelineConfigurationBody = Std.File.Invoke(new()
 *         {
 *             Input = "example.yaml",
 *         }).Apply(invoke => invoke.Result),
 *         MaxUnits = 1,
 *         MinUnits = 1,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/opensearchingest"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		invokeFile, err := std.File(ctx, &std.FileArgs{
 * 			Input: "example.yaml",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = opensearchingest.NewPipeline(ctx, "example", &opensearchingest.PipelineArgs{
 * 			PipelineName:              pulumi.String("example"),
 * 			PipelineConfigurationBody: pulumi.String(invokeFile.Result),
 * 			MaxUnits:                  pulumi.Int(1),
 * 			MinUnits:                  pulumi.Int(1),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearchingest.Pipeline;
 * import com.pulumi.aws.opensearchingest.PipelineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Pipeline("example", PipelineArgs.builder()
 *             .pipelineName("example")
 *             .pipelineConfigurationBody(StdFunctions.file(FileArgs.builder()
 *                 .input("example.yaml")
 *                 .build()).result())
 *             .maxUnits(1)
 *             .minUnits(1)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:opensearchingest:Pipeline
 *     properties:
 *       pipelineName: example
 *       pipelineConfigurationBody:
 *         fn::invoke:
 *           Function: std:file
 *           Arguments:
 *             input: example.yaml
 *           Return: result
 *       maxUnits: 1
 *       minUnits: 1
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import OpenSearch Ingestion Pipeline using the `id`. For example:
 * ```sh
 * $ pulumi import aws:opensearchingest/pipeline:Pipeline example example
 * ```
 * @property bufferOptions Key-value pairs to configure persistent buffering for the pipeline. See `buffer_options` below.
 * @property encryptionAtRestOptions Key-value pairs to configure encryption for data that is written to a persistent buffer. See `encryption_at_rest_options` below.
 * @property logPublishingOptions Key-value pairs to configure log publishing. See `log_publishing_options` below.
 * @property maxUnits The maximum pipeline capacity, in Ingestion Compute Units (ICUs).
 * @property minUnits The minimum pipeline capacity, in Ingestion Compute Units (ICUs).
 * @property pipelineConfigurationBody The pipeline configuration in YAML format. This argument accepts the pipeline configuration as a string or within a .yaml file. If you provide the configuration as a string, each new line must be escaped with \n.
 * @property pipelineName The name of the OpenSearch Ingestion pipeline to create. Pipeline names are unique across the pipelines owned by an account within an AWS Region.
 * The following arguments are optional:
 * @property tags A map of tags to assign to the pipeline. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property timeouts
 * @property vpcOptions Container for the values required to configure VPC access for the pipeline. If you don't specify these values, OpenSearch Ingestion creates the pipeline with a public endpoint. See `vpc_options` below.
 */
public data class PipelineArgs(
    public val bufferOptions: Output<PipelineBufferOptionsArgs>? = null,
    public val encryptionAtRestOptions: Output<PipelineEncryptionAtRestOptionsArgs>? = null,
    public val logPublishingOptions: Output<PipelineLogPublishingOptionsArgs>? = null,
    public val maxUnits: Output<Int>? = null,
    public val minUnits: Output<Int>? = null,
    public val pipelineConfigurationBody: Output<String>? = null,
    public val pipelineName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeouts: Output<PipelineTimeoutsArgs>? = null,
    public val vpcOptions: Output<PipelineVpcOptionsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.opensearchingest.PipelineArgs> {
    override fun toJava(): com.pulumi.aws.opensearchingest.PipelineArgs =
        com.pulumi.aws.opensearchingest.PipelineArgs.builder()
            .bufferOptions(bufferOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .encryptionAtRestOptions(
                encryptionAtRestOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .logPublishingOptions(
                logPublishingOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .maxUnits(maxUnits?.applyValue({ args0 -> args0 }))
            .minUnits(minUnits?.applyValue({ args0 -> args0 }))
            .pipelineConfigurationBody(pipelineConfigurationBody?.applyValue({ args0 -> args0 }))
            .pipelineName(pipelineName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vpcOptions(vpcOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [PipelineArgs].
 */
@PulumiTagMarker
public class PipelineArgsBuilder internal constructor() {
    private var bufferOptions: Output<PipelineBufferOptionsArgs>? = null

    private var encryptionAtRestOptions: Output<PipelineEncryptionAtRestOptionsArgs>? = null

    private var logPublishingOptions: Output<PipelineLogPublishingOptionsArgs>? = null

    private var maxUnits: Output<Int>? = null

    private var minUnits: Output<Int>? = null

    private var pipelineConfigurationBody: Output<String>? = null

    private var pipelineName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeouts: Output<PipelineTimeoutsArgs>? = null

    private var vpcOptions: Output<PipelineVpcOptionsArgs>? = null

    /**
     * @param value Key-value pairs to configure persistent buffering for the pipeline. See `buffer_options` below.
     */
    @JvmName("wnollvvotvlxbkya")
    public suspend fun bufferOptions(`value`: Output<PipelineBufferOptionsArgs>) {
        this.bufferOptions = value
    }

    /**
     * @param value Key-value pairs to configure encryption for data that is written to a persistent buffer. See `encryption_at_rest_options` below.
     */
    @JvmName("pdxngbexmtonlolh")
    public suspend fun encryptionAtRestOptions(`value`: Output<PipelineEncryptionAtRestOptionsArgs>) {
        this.encryptionAtRestOptions = value
    }

    /**
     * @param value Key-value pairs to configure log publishing. See `log_publishing_options` below.
     */
    @JvmName("fbirsehgwdmtldfq")
    public suspend fun logPublishingOptions(`value`: Output<PipelineLogPublishingOptionsArgs>) {
        this.logPublishingOptions = value
    }

    /**
     * @param value The maximum pipeline capacity, in Ingestion Compute Units (ICUs).
     */
    @JvmName("cjexvivnrykafkfm")
    public suspend fun maxUnits(`value`: Output<Int>) {
        this.maxUnits = value
    }

    /**
     * @param value The minimum pipeline capacity, in Ingestion Compute Units (ICUs).
     */
    @JvmName("mteycmkvygywtgyp")
    public suspend fun minUnits(`value`: Output<Int>) {
        this.minUnits = value
    }

    /**
     * @param value The pipeline configuration in YAML format. This argument accepts the pipeline configuration as a string or within a .yaml file. If you provide the configuration as a string, each new line must be escaped with \n.
     */
    @JvmName("jtwrskakofiaduht")
    public suspend fun pipelineConfigurationBody(`value`: Output<String>) {
        this.pipelineConfigurationBody = value
    }

    /**
     * @param value The name of the OpenSearch Ingestion pipeline to create. Pipeline names are unique across the pipelines owned by an account within an AWS Region.
     * The following arguments are optional:
     */
    @JvmName("iinipvkshxkxetsx")
    public suspend fun pipelineName(`value`: Output<String>) {
        this.pipelineName = value
    }

    /**
     * @param value A map of tags to assign to the pipeline. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xltwxddthlyktgbg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("oyxpnxodhohcprqh")
    public suspend fun timeouts(`value`: Output<PipelineTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value Container for the values required to configure VPC access for the pipeline. If you don't specify these values, OpenSearch Ingestion creates the pipeline with a public endpoint. See `vpc_options` below.
     */
    @JvmName("jtiyfwtaxmnaelib")
    public suspend fun vpcOptions(`value`: Output<PipelineVpcOptionsArgs>) {
        this.vpcOptions = value
    }

    /**
     * @param value Key-value pairs to configure persistent buffering for the pipeline. See `buffer_options` below.
     */
    @JvmName("ayoueuonjcsmysqe")
    public suspend fun bufferOptions(`value`: PipelineBufferOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bufferOptions = mapped
    }

    /**
     * @param argument Key-value pairs to configure persistent buffering for the pipeline. See `buffer_options` below.
     */
    @JvmName("qavpowsbnwbuxgas")
    public suspend fun bufferOptions(argument: suspend PipelineBufferOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = PipelineBufferOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.bufferOptions = mapped
    }

    /**
     * @param value Key-value pairs to configure encryption for data that is written to a persistent buffer. See `encryption_at_rest_options` below.
     */
    @JvmName("kyriwgrlbqpppdfy")
    public suspend fun encryptionAtRestOptions(`value`: PipelineEncryptionAtRestOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionAtRestOptions = mapped
    }

    /**
     * @param argument Key-value pairs to configure encryption for data that is written to a persistent buffer. See `encryption_at_rest_options` below.
     */
    @JvmName("xcssqvthendtnmfv")
    public suspend fun encryptionAtRestOptions(argument: suspend PipelineEncryptionAtRestOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = PipelineEncryptionAtRestOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryptionAtRestOptions = mapped
    }

    /**
     * @param value Key-value pairs to configure log publishing. See `log_publishing_options` below.
     */
    @JvmName("jrpxncdaefnwomwy")
    public suspend fun logPublishingOptions(`value`: PipelineLogPublishingOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logPublishingOptions = mapped
    }

    /**
     * @param argument Key-value pairs to configure log publishing. See `log_publishing_options` below.
     */
    @JvmName("ohiiuprwedrtjmpr")
    public suspend fun logPublishingOptions(argument: suspend PipelineLogPublishingOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = PipelineLogPublishingOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.logPublishingOptions = mapped
    }

    /**
     * @param value The maximum pipeline capacity, in Ingestion Compute Units (ICUs).
     */
    @JvmName("vntgykymtheqterg")
    public suspend fun maxUnits(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxUnits = mapped
    }

    /**
     * @param value The minimum pipeline capacity, in Ingestion Compute Units (ICUs).
     */
    @JvmName("rsjctwtbvadxaoji")
    public suspend fun minUnits(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minUnits = mapped
    }

    /**
     * @param value The pipeline configuration in YAML format. This argument accepts the pipeline configuration as a string or within a .yaml file. If you provide the configuration as a string, each new line must be escaped with \n.
     */
    @JvmName("mwmwbwtsblklgvjj")
    public suspend fun pipelineConfigurationBody(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelineConfigurationBody = mapped
    }

    /**
     * @param value The name of the OpenSearch Ingestion pipeline to create. Pipeline names are unique across the pipelines owned by an account within an AWS Region.
     * The following arguments are optional:
     */
    @JvmName("pdydojuwtrmcmixa")
    public suspend fun pipelineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelineName = mapped
    }

    /**
     * @param value A map of tags to assign to the pipeline. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("utpffvciwandahdh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the pipeline. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("aqgbxobawsskjvva")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("mjrtmvweksnryjqk")
    public suspend fun timeouts(`value`: PipelineTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("vrjxnktyxbnichtn")
    public suspend fun timeouts(argument: suspend PipelineTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = PipelineTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    /**
     * @param value Container for the values required to configure VPC access for the pipeline. If you don't specify these values, OpenSearch Ingestion creates the pipeline with a public endpoint. See `vpc_options` below.
     */
    @JvmName("tqapgivxsslktqdb")
    public suspend fun vpcOptions(`value`: PipelineVpcOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcOptions = mapped
    }

    /**
     * @param argument Container for the values required to configure VPC access for the pipeline. If you don't specify these values, OpenSearch Ingestion creates the pipeline with a public endpoint. See `vpc_options` below.
     */
    @JvmName("lpcqqdvtxexjbnhp")
    public suspend fun vpcOptions(argument: suspend PipelineVpcOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = PipelineVpcOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vpcOptions = mapped
    }

    internal fun build(): PipelineArgs = PipelineArgs(
        bufferOptions = bufferOptions,
        encryptionAtRestOptions = encryptionAtRestOptions,
        logPublishingOptions = logPublishingOptions,
        maxUnits = maxUnits,
        minUnits = minUnits,
        pipelineConfigurationBody = pipelineConfigurationBody,
        pipelineName = pipelineName,
        tags = tags,
        timeouts = timeouts,
        vpcOptions = vpcOptions,
    )
}
