@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearchingest.kotlin.inputs

import com.pulumi.aws.opensearchingest.inputs.PipelineBufferOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property persistentBufferEnabled Whether persistent buffering should be enabled.
 */
public data class PipelineBufferOptionsArgs(
    public val persistentBufferEnabled: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.aws.opensearchingest.inputs.PipelineBufferOptionsArgs> {
    override fun toJava(): com.pulumi.aws.opensearchingest.inputs.PipelineBufferOptionsArgs =
        com.pulumi.aws.opensearchingest.inputs.PipelineBufferOptionsArgs.builder()
            .persistentBufferEnabled(persistentBufferEnabled.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipelineBufferOptionsArgs].
 */
@PulumiTagMarker
public class PipelineBufferOptionsArgsBuilder internal constructor() {
    private var persistentBufferEnabled: Output<Boolean>? = null

    /**
     * @param value Whether persistent buffering should be enabled.
     */
    @JvmName("gylbcmdkxwphvniw")
    public suspend fun persistentBufferEnabled(`value`: Output<Boolean>) {
        this.persistentBufferEnabled = value
    }

    /**
     * @param value Whether persistent buffering should be enabled.
     */
    @JvmName("leqwwtuspkrriwrm")
    public suspend fun persistentBufferEnabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.persistentBufferEnabled = mapped
    }

    internal fun build(): PipelineBufferOptionsArgs = PipelineBufferOptionsArgs(
        persistentBufferEnabled = persistentBufferEnabled ?: throw
            PulumiNullFieldException("persistentBufferEnabled"),
    )
}
