@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearchingest.kotlin.inputs

import com.pulumi.aws.opensearchingest.inputs.PipelineEncryptionAtRestOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property kmsKeyArn The ARN of the KMS key used to encrypt data-at-rest in OpenSearch Ingestion. By default, data is encrypted using an AWS owned key.
 */
public data class PipelineEncryptionAtRestOptionsArgs(
    public val kmsKeyArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.opensearchingest.inputs.PipelineEncryptionAtRestOptionsArgs> {
    override fun toJava(): com.pulumi.aws.opensearchingest.inputs.PipelineEncryptionAtRestOptionsArgs = com.pulumi.aws.opensearchingest.inputs.PipelineEncryptionAtRestOptionsArgs.builder()
        .kmsKeyArn(kmsKeyArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipelineEncryptionAtRestOptionsArgs].
 */
@PulumiTagMarker
public class PipelineEncryptionAtRestOptionsArgsBuilder internal constructor() {
    private var kmsKeyArn: Output<String>? = null

    /**
     * @param value The ARN of the KMS key used to encrypt data-at-rest in OpenSearch Ingestion. By default, data is encrypted using an AWS owned key.
     */
    @JvmName("utuwcxjcuwkgevnb")
    public suspend fun kmsKeyArn(`value`: Output<String>) {
        this.kmsKeyArn = value
    }

    /**
     * @param value The ARN of the KMS key used to encrypt data-at-rest in OpenSearch Ingestion. By default, data is encrypted using an AWS owned key.
     */
    @JvmName("lmtbxmdhdhuqbqqm")
    public suspend fun kmsKeyArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kmsKeyArn = mapped
    }

    internal fun build(): PipelineEncryptionAtRestOptionsArgs = PipelineEncryptionAtRestOptionsArgs(
        kmsKeyArn = kmsKeyArn ?: throw PulumiNullFieldException("kmsKeyArn"),
    )
}
