@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearchingest.kotlin.inputs

import com.pulumi.aws.opensearchingest.inputs.PipelineLogPublishingOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property cloudwatchLogDestination The destination for OpenSearch Ingestion logs sent to Amazon CloudWatch Logs. This parameter is required if IsLoggingEnabled is set to true. See `cloudwatch_log_destination` below.
 * @property isLoggingEnabled Whether logs should be published.
 */
public data class PipelineLogPublishingOptionsArgs(
    public val cloudwatchLogDestination: Output<PipelineLogPublishingOptionsCloudwatchLogDestinationArgs>? = null,
    public val isLoggingEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.opensearchingest.inputs.PipelineLogPublishingOptionsArgs> {
    override fun toJava(): com.pulumi.aws.opensearchingest.inputs.PipelineLogPublishingOptionsArgs =
        com.pulumi.aws.opensearchingest.inputs.PipelineLogPublishingOptionsArgs.builder()
            .cloudwatchLogDestination(
                cloudwatchLogDestination?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .isLoggingEnabled(isLoggingEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipelineLogPublishingOptionsArgs].
 */
@PulumiTagMarker
public class PipelineLogPublishingOptionsArgsBuilder internal constructor() {
    private var cloudwatchLogDestination:
        Output<PipelineLogPublishingOptionsCloudwatchLogDestinationArgs>? = null

    private var isLoggingEnabled: Output<Boolean>? = null

    /**
     * @param value The destination for OpenSearch Ingestion logs sent to Amazon CloudWatch Logs. This parameter is required if IsLoggingEnabled is set to true. See `cloudwatch_log_destination` below.
     */
    @JvmName("nwjlkofnobcedjxd")
    public suspend fun cloudwatchLogDestination(`value`: Output<PipelineLogPublishingOptionsCloudwatchLogDestinationArgs>) {
        this.cloudwatchLogDestination = value
    }

    /**
     * @param value Whether logs should be published.
     */
    @JvmName("qhwpfuubxfwawahl")
    public suspend fun isLoggingEnabled(`value`: Output<Boolean>) {
        this.isLoggingEnabled = value
    }

    /**
     * @param value The destination for OpenSearch Ingestion logs sent to Amazon CloudWatch Logs. This parameter is required if IsLoggingEnabled is set to true. See `cloudwatch_log_destination` below.
     */
    @JvmName("hpocxhfujtkjptjo")
    public suspend fun cloudwatchLogDestination(`value`: PipelineLogPublishingOptionsCloudwatchLogDestinationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchLogDestination = mapped
    }

    /**
     * @param argument The destination for OpenSearch Ingestion logs sent to Amazon CloudWatch Logs. This parameter is required if IsLoggingEnabled is set to true. See `cloudwatch_log_destination` below.
     */
    @JvmName("buxetmcpkbkcfbom")
    public suspend fun cloudwatchLogDestination(argument: suspend PipelineLogPublishingOptionsCloudwatchLogDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = PipelineLogPublishingOptionsCloudwatchLogDestinationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.cloudwatchLogDestination = mapped
    }

    /**
     * @param value Whether logs should be published.
     */
    @JvmName("xbkfljpdaaeuvrov")
    public suspend fun isLoggingEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isLoggingEnabled = mapped
    }

    internal fun build(): PipelineLogPublishingOptionsArgs = PipelineLogPublishingOptionsArgs(
        cloudwatchLogDestination = cloudwatchLogDestination,
        isLoggingEnabled = isLoggingEnabled,
    )
}
