@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearchingest.kotlin.inputs

import com.pulumi.aws.opensearchingest.inputs.PipelineLogPublishingOptionsCloudwatchLogDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property logGroup The name of the CloudWatch Logs group to send pipeline logs to. You can specify an existing log group or create a new one. For example, /aws/OpenSearchService/IngestionService/my-pipeline.
 */
public data class PipelineLogPublishingOptionsCloudwatchLogDestinationArgs(
    public val logGroup: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.opensearchingest.inputs.PipelineLogPublishingOptionsCloudwatchLogDestinationArgs> {
    override fun toJava(): com.pulumi.aws.opensearchingest.inputs.PipelineLogPublishingOptionsCloudwatchLogDestinationArgs =
        com.pulumi.aws.opensearchingest.inputs.PipelineLogPublishingOptionsCloudwatchLogDestinationArgs.builder()
            .logGroup(logGroup.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipelineLogPublishingOptionsCloudwatchLogDestinationArgs].
 */
@PulumiTagMarker
public class PipelineLogPublishingOptionsCloudwatchLogDestinationArgsBuilder internal constructor() {
    private var logGroup: Output<String>? = null

    /**
     * @param value The name of the CloudWatch Logs group to send pipeline logs to. You can specify an existing log group or create a new one. For example, /aws/OpenSearchService/IngestionService/my-pipeline.
     */
    @JvmName("asomwsvvfbcklvbe")
    public suspend fun logGroup(`value`: Output<String>) {
        this.logGroup = value
    }

    /**
     * @param value The name of the CloudWatch Logs group to send pipeline logs to. You can specify an existing log group or create a new one. For example, /aws/OpenSearchService/IngestionService/my-pipeline.
     */
    @JvmName("uqtsimvjlxdecxms")
    public suspend fun logGroup(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logGroup = mapped
    }

    internal fun build(): PipelineLogPublishingOptionsCloudwatchLogDestinationArgs =
        PipelineLogPublishingOptionsCloudwatchLogDestinationArgs(
            logGroup = logGroup ?: throw PulumiNullFieldException("logGroup"),
        )
}
