@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearchingest.kotlin.inputs

import com.pulumi.aws.opensearchingest.inputs.PipelineVpcOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property securityGroupIds A list of security groups associated with the VPC endpoint.
 * @property subnetIds A list of subnet IDs associated with the VPC endpoint.
 */
public data class PipelineVpcOptionsArgs(
    public val securityGroupIds: Output<List<String>>? = null,
    public val subnetIds: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.opensearchingest.inputs.PipelineVpcOptionsArgs> {
    override fun toJava(): com.pulumi.aws.opensearchingest.inputs.PipelineVpcOptionsArgs =
        com.pulumi.aws.opensearchingest.inputs.PipelineVpcOptionsArgs.builder()
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnetIds(subnetIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [PipelineVpcOptionsArgs].
 */
@PulumiTagMarker
public class PipelineVpcOptionsArgsBuilder internal constructor() {
    private var securityGroupIds: Output<List<String>>? = null

    private var subnetIds: Output<List<String>>? = null

    /**
     * @param value A list of security groups associated with the VPC endpoint.
     */
    @JvmName("nqxqffsfqflmeobc")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("vkxcvfqdbdabsrrc")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values A list of security groups associated with the VPC endpoint.
     */
    @JvmName("saimwmbbkydaxsnn")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value A list of subnet IDs associated with the VPC endpoint.
     */
    @JvmName("aeyhjuejeidnqget")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("puadtkcxfrcigttm")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values A list of subnet IDs associated with the VPC endpoint.
     */
    @JvmName("pivxdnolqdfbxlhl")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value A list of security groups associated with the VPC endpoint.
     */
    @JvmName("fqxeyfsisahcwrtr")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values A list of security groups associated with the VPC endpoint.
     */
    @JvmName("eournxdtpgxwctoo")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value A list of subnet IDs associated with the VPC endpoint.
     */
    @JvmName("obscvlnifftjiahb")
    public suspend fun subnetIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values A list of subnet IDs associated with the VPC endpoint.
     */
    @JvmName("htnqnjskgvpjwjki")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    internal fun build(): PipelineVpcOptionsArgs = PipelineVpcOptionsArgs(
        securityGroupIds = securityGroupIds,
        subnetIds = subnetIds ?: throw PulumiNullFieldException("subnetIds"),
    )
}
