@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearchingest.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property kmsKeyArn The ARN of the KMS key used to encrypt data-at-rest in OpenSearch Ingestion. By default, data is encrypted using an AWS owned key.
 */
public data class PipelineEncryptionAtRestOptions(
    public val kmsKeyArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.opensearchingest.outputs.PipelineEncryptionAtRestOptions): PipelineEncryptionAtRestOptions = PipelineEncryptionAtRestOptions(
            kmsKeyArn = javaType.kmsKeyArn(),
        )
    }
}
