@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearchingest.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property cloudwatchLogDestination The destination for OpenSearch Ingestion logs sent to Amazon CloudWatch Logs. This parameter is required if IsLoggingEnabled is set to true. See `cloudwatch_log_destination` below.
 * @property isLoggingEnabled Whether logs should be published.
 */
public data class PipelineLogPublishingOptions(
    public val cloudwatchLogDestination: PipelineLogPublishingOptionsCloudwatchLogDestination? = null,
    public val isLoggingEnabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.opensearchingest.outputs.PipelineLogPublishingOptions): PipelineLogPublishingOptions = PipelineLogPublishingOptions(
            cloudwatchLogDestination = javaType.cloudwatchLogDestination().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.opensearchingest.kotlin.outputs.PipelineLogPublishingOptionsCloudwatchLogDestination.Companion.toKotlin(args0)
                })
            }).orElse(null),
            isLoggingEnabled = javaType.isLoggingEnabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
