@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearchingest.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property securityGroupIds A list of security groups associated with the VPC endpoint.
 * @property subnetIds A list of subnet IDs associated with the VPC endpoint.
 */
public data class PipelineVpcOptions(
    public val securityGroupIds: List<String>? = null,
    public val subnetIds: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.opensearchingest.outputs.PipelineVpcOptions): PipelineVpcOptions = PipelineVpcOptions(
            securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
            subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
        )
    }
}
