@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin

import com.pulumi.aws.opsworks.ApplicationArgs.builder
import com.pulumi.aws.opsworks.kotlin.inputs.ApplicationAppSourceArgs
import com.pulumi.aws.opsworks.kotlin.inputs.ApplicationAppSourceArgsBuilder
import com.pulumi.aws.opsworks.kotlin.inputs.ApplicationEnvironmentArgs
import com.pulumi.aws.opsworks.kotlin.inputs.ApplicationEnvironmentArgsBuilder
import com.pulumi.aws.opsworks.kotlin.inputs.ApplicationSslConfigurationArgs
import com.pulumi.aws.opsworks.kotlin.inputs.ApplicationSslConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an OpsWorks application resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const foo_app = new aws.opsworks.Application("foo-app", {
 *     name: "foobar application",
 *     shortName: "foobar",
 *     stackId: main.id,
 *     type: "rails",
 *     description: "This is a Rails application",
 *     domains: [
 *         "example.com",
 *         "sub.example.com",
 *     ],
 *     environments: [{
 *         key: "key",
 *         value: "value",
 *         secure: false,
 *     }],
 *     appSources: [{
 *         type: "git",
 *         revision: "master",
 *         url: "https://github.com/example.git",
 *     }],
 *     enableSsl: true,
 *     sslConfigurations: [{
 *         privateKey: std.file({
 *             input: "./foobar.key",
 *         }).then(invoke => invoke.result),
 *         certificate: std.file({
 *             input: "./foobar.crt",
 *         }).then(invoke => invoke.result),
 *     }],
 *     documentRoot: "public",
 *     autoBundleOnDeploy: "true",
 *     railsEnv: "staging",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * foo_app = aws.opsworks.Application("foo-app",
 *     name="foobar application",
 *     short_name="foobar",
 *     stack_id=main["id"],
 *     type="rails",
 *     description="This is a Rails application",
 *     domains=[
 *         "example.com",
 *         "sub.example.com",
 *     ],
 *     environments=[{
 *         "key": "key",
 *         "value": "value",
 *         "secure": False,
 *     }],
 *     app_sources=[{
 *         "type": "git",
 *         "revision": "master",
 *         "url": "https://github.com/example.git",
 *     }],
 *     enable_ssl=True,
 *     ssl_configurations=[{
 *         "private_key": std.file(input="./foobar.key").result,
 *         "certificate": std.file(input="./foobar.crt").result,
 *     }],
 *     document_root="public",
 *     auto_bundle_on_deploy="true",
 *     rails_env="staging")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo_app = new Aws.OpsWorks.Application("foo-app", new()
 *     {
 *         Name = "foobar application",
 *         ShortName = "foobar",
 *         StackId = main.Id,
 *         Type = "rails",
 *         Description = "This is a Rails application",
 *         Domains = new[]
 *         {
 *             "example.com",
 *             "sub.example.com",
 *         },
 *         Environments = new[]
 *         {
 *             new Aws.OpsWorks.Inputs.ApplicationEnvironmentArgs
 *             {
 *                 Key = "key",
 *                 Value = "value",
 *                 Secure = false,
 *             },
 *         },
 *         AppSources = new[]
 *         {
 *             new Aws.OpsWorks.Inputs.ApplicationAppSourceArgs
 *             {
 *                 Type = "git",
 *                 Revision = "master",
 *                 Url = "https://github.com/example.git",
 *             },
 *         },
 *         EnableSsl = true,
 *         SslConfigurations = new[]
 *         {
 *             new Aws.OpsWorks.Inputs.ApplicationSslConfigurationArgs
 *             {
 *                 PrivateKey = Std.File.Invoke(new()
 *                 {
 *                     Input = "./foobar.key",
 *                 }).Apply(invoke => invoke.Result),
 *                 Certificate = Std.File.Invoke(new()
 *                 {
 *                     Input = "./foobar.crt",
 *                 }).Apply(invoke => invoke.Result),
 *             },
 *         },
 *         DocumentRoot = "public",
 *         AutoBundleOnDeploy = "true",
 *         RailsEnv = "staging",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/opsworks"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		invokeFile, err := std.File(ctx, &std.FileArgs{
 * 			Input: "./foobar.key",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		invokeFile1, err := std.File(ctx, &std.FileArgs{
 * 			Input: "./foobar.crt",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = opsworks.NewApplication(ctx, "foo-app", &opsworks.ApplicationArgs{
 * 			Name:        pulumi.String("foobar application"),
 * 			ShortName:   pulumi.String("foobar"),
 * 			StackId:     pulumi.Any(main.Id),
 * 			Type:        pulumi.String("rails"),
 * 			Description: pulumi.String("This is a Rails application"),
 * 			Domains: pulumi.StringArray{
 * 				pulumi.String("example.com"),
 * 				pulumi.String("sub.example.com"),
 * 			},
 * 			Environments: opsworks.ApplicationEnvironmentArray{
 * 				&opsworks.ApplicationEnvironmentArgs{
 * 					Key:    pulumi.String("key"),
 * 					Value:  pulumi.String("value"),
 * 					Secure: pulumi.Bool(false),
 * 				},
 * 			},
 * 			AppSources: opsworks.ApplicationAppSourceArray{
 * 				&opsworks.ApplicationAppSourceArgs{
 * 					Type:     pulumi.String("git"),
 * 					Revision: pulumi.String("master"),
 * 					Url:      pulumi.String("https://github.com/example.git"),
 * 				},
 * 			},
 * 			EnableSsl: pulumi.Bool(true),
 * 			SslConfigurations: opsworks.ApplicationSslConfigurationArray{
 * 				&opsworks.ApplicationSslConfigurationArgs{
 * 					PrivateKey:  pulumi.String(invokeFile.Result),
 * 					Certificate: pulumi.String(invokeFile1.Result),
 * 				},
 * 			},
 * 			DocumentRoot:       pulumi.String("public"),
 * 			AutoBundleOnDeploy: pulumi.String("true"),
 * 			RailsEnv:           pulumi.String("staging"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opsworks.Application;
 * import com.pulumi.aws.opsworks.ApplicationArgs;
 * import com.pulumi.aws.opsworks.inputs.ApplicationEnvironmentArgs;
 * import com.pulumi.aws.opsworks.inputs.ApplicationAppSourceArgs;
 * import com.pulumi.aws.opsworks.inputs.ApplicationSslConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo_app = new Application("foo-app", ApplicationArgs.builder()
 *             .name("foobar application")
 *             .shortName("foobar")
 *             .stackId(main.id())
 *             .type("rails")
 *             .description("This is a Rails application")
 *             .domains(
 *                 "example.com",
 *                 "sub.example.com")
 *             .environments(ApplicationEnvironmentArgs.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .secure(false)
 *                 .build())
 *             .appSources(ApplicationAppSourceArgs.builder()
 *                 .type("git")
 *                 .revision("master")
 *                 .url("https://github.com/example.git")
 *                 .build())
 *             .enableSsl(true)
 *             .sslConfigurations(ApplicationSslConfigurationArgs.builder()
 *                 .privateKey(StdFunctions.file(FileArgs.builder()
 *                     .input("./foobar.key")
 *                     .build()).result())
 *                 .certificate(StdFunctions.file(FileArgs.builder()
 *                     .input("./foobar.crt")
 *                     .build()).result())
 *                 .build())
 *             .documentRoot("public")
 *             .autoBundleOnDeploy(true)
 *             .railsEnv("staging")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo-app:
 *     type: aws:opsworks:Application
 *     properties:
 *       name: foobar application
 *       shortName: foobar
 *       stackId: ${main.id}
 *       type: rails
 *       description: This is a Rails application
 *       domains:
 *         - example.com
 *         - sub.example.com
 *       environments:
 *         - key: key
 *           value: value
 *           secure: false
 *       appSources:
 *         - type: git
 *           revision: master
 *           url: https://github.com/example.git
 *       enableSsl: true
 *       sslConfigurations:
 *         - privateKey:
 *             fn::invoke:
 *               Function: std:file
 *               Arguments:
 *                 input: ./foobar.key
 *               Return: result
 *           certificate:
 *             fn::invoke:
 *               Function: std:file
 *               Arguments:
 *                 input: ./foobar.crt
 *               Return: result
 *       documentRoot: public
 *       autoBundleOnDeploy: true
 *       railsEnv: staging
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Opsworks Application using the `id`. For example:
 * ```sh
 * $ pulumi import aws:opsworks/application:Application test <id>
 * ```
 * @property appSources SCM configuration of the app as described below.
 * @property autoBundleOnDeploy Run bundle install when deploying for application of type `rails`.
 * @property awsFlowRubySettings Specify activity and workflow workers for your app using the aws-flow gem.
 * @property dataSourceArn The data source's ARN.
 * @property dataSourceDatabaseName The database name.
 * @property dataSourceType The data source's type one of `AutoSelectOpsworksMysqlInstance`, `OpsworksMysqlInstance`, or `RdsDbInstance`.
 * @property description A description of the app.
 * @property documentRoot Subfolder for the document root for application of type `rails`.
 * @property domains A list of virtual host alias.
 * @property enableSsl Whether to enable SSL for the app. This must be set in order to let `ssl_configuration.private_key`, `ssl_configuration.certificate` and `ssl_configuration.chain` take effect.
 * @property environments Object to define environment variables.  Object is described below.
 * @property name A human-readable name for the application.
 * @property railsEnv The name of the Rails environment for application of type `rails`.
 * @property shortName A short, machine-readable name for the application. This can only be defined on resource creation and ignored on resource update.
 * @property sslConfigurations The SSL configuration of the app. Object is described below.
 * @property stackId ID of the stack the application will belong to.
 * @property type Opsworks application type. One of `aws-flow-ruby`, `java`, `rails`, `php`, `nodejs`, `static` or `other`.
 */
public data class ApplicationArgs(
    public val appSources: Output<List<ApplicationAppSourceArgs>>? = null,
    public val autoBundleOnDeploy: Output<String>? = null,
    public val awsFlowRubySettings: Output<String>? = null,
    public val dataSourceArn: Output<String>? = null,
    public val dataSourceDatabaseName: Output<String>? = null,
    public val dataSourceType: Output<String>? = null,
    public val description: Output<String>? = null,
    public val documentRoot: Output<String>? = null,
    public val domains: Output<List<String>>? = null,
    public val enableSsl: Output<Boolean>? = null,
    public val environments: Output<List<ApplicationEnvironmentArgs>>? = null,
    public val name: Output<String>? = null,
    public val railsEnv: Output<String>? = null,
    public val shortName: Output<String>? = null,
    public val sslConfigurations: Output<List<ApplicationSslConfigurationArgs>>? = null,
    public val stackId: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.opsworks.ApplicationArgs> {
    override fun toJava(): com.pulumi.aws.opsworks.ApplicationArgs =
        com.pulumi.aws.opsworks.ApplicationArgs.builder()
            .appSources(
                appSources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .autoBundleOnDeploy(autoBundleOnDeploy?.applyValue({ args0 -> args0 }))
            .awsFlowRubySettings(awsFlowRubySettings?.applyValue({ args0 -> args0 }))
            .dataSourceArn(dataSourceArn?.applyValue({ args0 -> args0 }))
            .dataSourceDatabaseName(dataSourceDatabaseName?.applyValue({ args0 -> args0 }))
            .dataSourceType(dataSourceType?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .documentRoot(documentRoot?.applyValue({ args0 -> args0 }))
            .domains(domains?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .enableSsl(enableSsl?.applyValue({ args0 -> args0 }))
            .environments(
                environments?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .railsEnv(railsEnv?.applyValue({ args0 -> args0 }))
            .shortName(shortName?.applyValue({ args0 -> args0 }))
            .sslConfigurations(
                sslConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .stackId(stackId?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationArgs].
 */
@PulumiTagMarker
public class ApplicationArgsBuilder internal constructor() {
    private var appSources: Output<List<ApplicationAppSourceArgs>>? = null

    private var autoBundleOnDeploy: Output<String>? = null

    private var awsFlowRubySettings: Output<String>? = null

    private var dataSourceArn: Output<String>? = null

    private var dataSourceDatabaseName: Output<String>? = null

    private var dataSourceType: Output<String>? = null

    private var description: Output<String>? = null

    private var documentRoot: Output<String>? = null

    private var domains: Output<List<String>>? = null

    private var enableSsl: Output<Boolean>? = null

    private var environments: Output<List<ApplicationEnvironmentArgs>>? = null

    private var name: Output<String>? = null

    private var railsEnv: Output<String>? = null

    private var shortName: Output<String>? = null

    private var sslConfigurations: Output<List<ApplicationSslConfigurationArgs>>? = null

    private var stackId: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value SCM configuration of the app as described below.
     */
    @JvmName("cfccswtdwcxdhify")
    public suspend fun appSources(`value`: Output<List<ApplicationAppSourceArgs>>) {
        this.appSources = value
    }

    @JvmName("pahfdettlrqadxxd")
    public suspend fun appSources(vararg values: Output<ApplicationAppSourceArgs>) {
        this.appSources = Output.all(values.asList())
    }

    /**
     * @param values SCM configuration of the app as described below.
     */
    @JvmName("jgnskcvisneqbhuk")
    public suspend fun appSources(values: List<Output<ApplicationAppSourceArgs>>) {
        this.appSources = Output.all(values)
    }

    /**
     * @param value Run bundle install when deploying for application of type `rails`.
     */
    @JvmName("foudjtuoeekcuybi")
    public suspend fun autoBundleOnDeploy(`value`: Output<String>) {
        this.autoBundleOnDeploy = value
    }

    /**
     * @param value Specify activity and workflow workers for your app using the aws-flow gem.
     */
    @JvmName("cfmtpjktcpesdvxh")
    public suspend fun awsFlowRubySettings(`value`: Output<String>) {
        this.awsFlowRubySettings = value
    }

    /**
     * @param value The data source's ARN.
     */
    @JvmName("vjrkpulyegppkswu")
    public suspend fun dataSourceArn(`value`: Output<String>) {
        this.dataSourceArn = value
    }

    /**
     * @param value The database name.
     */
    @JvmName("tjkpxtxrqcfiwjmi")
    public suspend fun dataSourceDatabaseName(`value`: Output<String>) {
        this.dataSourceDatabaseName = value
    }

    /**
     * @param value The data source's type one of `AutoSelectOpsworksMysqlInstance`, `OpsworksMysqlInstance`, or `RdsDbInstance`.
     */
    @JvmName("kdamwcwouaxfphiw")
    public suspend fun dataSourceType(`value`: Output<String>) {
        this.dataSourceType = value
    }

    /**
     * @param value A description of the app.
     */
    @JvmName("uhmrpxlkomwgcpvt")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Subfolder for the document root for application of type `rails`.
     */
    @JvmName("hmflrswhqmnhkggl")
    public suspend fun documentRoot(`value`: Output<String>) {
        this.documentRoot = value
    }

    /**
     * @param value A list of virtual host alias.
     */
    @JvmName("fbtorkqjnwcxkyly")
    public suspend fun domains(`value`: Output<List<String>>) {
        this.domains = value
    }

    @JvmName("blkrdephprreoeru")
    public suspend fun domains(vararg values: Output<String>) {
        this.domains = Output.all(values.asList())
    }

    /**
     * @param values A list of virtual host alias.
     */
    @JvmName("ikjgxoimpkevpcbw")
    public suspend fun domains(values: List<Output<String>>) {
        this.domains = Output.all(values)
    }

    /**
     * @param value Whether to enable SSL for the app. This must be set in order to let `ssl_configuration.private_key`, `ssl_configuration.certificate` and `ssl_configuration.chain` take effect.
     */
    @JvmName("semgmmaiqphwivxt")
    public suspend fun enableSsl(`value`: Output<Boolean>) {
        this.enableSsl = value
    }

    /**
     * @param value Object to define environment variables.  Object is described below.
     */
    @JvmName("cmgyvdglcmdcmvss")
    public suspend fun environments(`value`: Output<List<ApplicationEnvironmentArgs>>) {
        this.environments = value
    }

    @JvmName("gisrrhatdwqbgrfe")
    public suspend fun environments(vararg values: Output<ApplicationEnvironmentArgs>) {
        this.environments = Output.all(values.asList())
    }

    /**
     * @param values Object to define environment variables.  Object is described below.
     */
    @JvmName("unpfgafvyhakvhih")
    public suspend fun environments(values: List<Output<ApplicationEnvironmentArgs>>) {
        this.environments = Output.all(values)
    }

    /**
     * @param value A human-readable name for the application.
     */
    @JvmName("inskuqtroqlnelxa")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the Rails environment for application of type `rails`.
     */
    @JvmName("omjxtweabbtkoomh")
    public suspend fun railsEnv(`value`: Output<String>) {
        this.railsEnv = value
    }

    /**
     * @param value A short, machine-readable name for the application. This can only be defined on resource creation and ignored on resource update.
     */
    @JvmName("cpurjdwjcelulmcj")
    public suspend fun shortName(`value`: Output<String>) {
        this.shortName = value
    }

    /**
     * @param value The SSL configuration of the app. Object is described below.
     */
    @JvmName("ofgrdsnjhqeukiqu")
    public suspend fun sslConfigurations(`value`: Output<List<ApplicationSslConfigurationArgs>>) {
        this.sslConfigurations = value
    }

    @JvmName("hbgkwebqollwkpxv")
    public suspend fun sslConfigurations(vararg values: Output<ApplicationSslConfigurationArgs>) {
        this.sslConfigurations = Output.all(values.asList())
    }

    /**
     * @param values The SSL configuration of the app. Object is described below.
     */
    @JvmName("kufkmltjeehflvke")
    public suspend fun sslConfigurations(values: List<Output<ApplicationSslConfigurationArgs>>) {
        this.sslConfigurations = Output.all(values)
    }

    /**
     * @param value ID of the stack the application will belong to.
     */
    @JvmName("ttrplbuffbudmjev")
    public suspend fun stackId(`value`: Output<String>) {
        this.stackId = value
    }

    /**
     * @param value Opsworks application type. One of `aws-flow-ruby`, `java`, `rails`, `php`, `nodejs`, `static` or `other`.
     */
    @JvmName("bjwfiwxgyxpgolpg")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value SCM configuration of the app as described below.
     */
    @JvmName("hteiuckeqjlkfuum")
    public suspend fun appSources(`value`: List<ApplicationAppSourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appSources = mapped
    }

    /**
     * @param argument SCM configuration of the app as described below.
     */
    @JvmName("kkkxxshasdrrhhyp")
    public suspend fun appSources(argument: List<suspend ApplicationAppSourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationAppSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.appSources = mapped
    }

    /**
     * @param argument SCM configuration of the app as described below.
     */
    @JvmName("sqwyspjcckjedgpn")
    public suspend fun appSources(vararg argument: suspend ApplicationAppSourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ApplicationAppSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.appSources = mapped
    }

    /**
     * @param argument SCM configuration of the app as described below.
     */
    @JvmName("jmpugptflbkavixd")
    public suspend fun appSources(argument: suspend ApplicationAppSourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ApplicationAppSourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.appSources = mapped
    }

    /**
     * @param values SCM configuration of the app as described below.
     */
    @JvmName("tqvnrhsmhisqpaxb")
    public suspend fun appSources(vararg values: ApplicationAppSourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.appSources = mapped
    }

    /**
     * @param value Run bundle install when deploying for application of type `rails`.
     */
    @JvmName("btausupmbofofyui")
    public suspend fun autoBundleOnDeploy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoBundleOnDeploy = mapped
    }

    /**
     * @param value Specify activity and workflow workers for your app using the aws-flow gem.
     */
    @JvmName("kdjtunetnqcklcke")
    public suspend fun awsFlowRubySettings(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsFlowRubySettings = mapped
    }

    /**
     * @param value The data source's ARN.
     */
    @JvmName("cdsnfbswdywhkapb")
    public suspend fun dataSourceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSourceArn = mapped
    }

    /**
     * @param value The database name.
     */
    @JvmName("ouocerhnwuvrpmwg")
    public suspend fun dataSourceDatabaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSourceDatabaseName = mapped
    }

    /**
     * @param value The data source's type one of `AutoSelectOpsworksMysqlInstance`, `OpsworksMysqlInstance`, or `RdsDbInstance`.
     */
    @JvmName("cestdqradwfmntnv")
    public suspend fun dataSourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSourceType = mapped
    }

    /**
     * @param value A description of the app.
     */
    @JvmName("covdsmrfwcthftjh")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Subfolder for the document root for application of type `rails`.
     */
    @JvmName("aseatubnjmsbibaj")
    public suspend fun documentRoot(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.documentRoot = mapped
    }

    /**
     * @param value A list of virtual host alias.
     */
    @JvmName("nokxofognrqwvusf")
    public suspend fun domains(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domains = mapped
    }

    /**
     * @param values A list of virtual host alias.
     */
    @JvmName("gejrqaouoomytxwa")
    public suspend fun domains(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domains = mapped
    }

    /**
     * @param value Whether to enable SSL for the app. This must be set in order to let `ssl_configuration.private_key`, `ssl_configuration.certificate` and `ssl_configuration.chain` take effect.
     */
    @JvmName("faisbikbjbxhjjqu")
    public suspend fun enableSsl(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableSsl = mapped
    }

    /**
     * @param value Object to define environment variables.  Object is described below.
     */
    @JvmName("efjgbiqqnvdfatjd")
    public suspend fun environments(`value`: List<ApplicationEnvironmentArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environments = mapped
    }

    /**
     * @param argument Object to define environment variables.  Object is described below.
     */
    @JvmName("gdufjqdiphetstgm")
    public suspend fun environments(argument: List<suspend ApplicationEnvironmentArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationEnvironmentArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.environments = mapped
    }

    /**
     * @param argument Object to define environment variables.  Object is described below.
     */
    @JvmName("hownomepvbjwswnq")
    public suspend fun environments(vararg argument: suspend ApplicationEnvironmentArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ApplicationEnvironmentArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.environments = mapped
    }

    /**
     * @param argument Object to define environment variables.  Object is described below.
     */
    @JvmName("dppyaklekrpfvdmg")
    public suspend fun environments(argument: suspend ApplicationEnvironmentArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ApplicationEnvironmentArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.environments = mapped
    }

    /**
     * @param values Object to define environment variables.  Object is described below.
     */
    @JvmName("dtbutphwfuxfvkkh")
    public suspend fun environments(vararg values: ApplicationEnvironmentArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environments = mapped
    }

    /**
     * @param value A human-readable name for the application.
     */
    @JvmName("qjorqbtgjbkpmlts")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the Rails environment for application of type `rails`.
     */
    @JvmName("crwtanlupbskgloc")
    public suspend fun railsEnv(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.railsEnv = mapped
    }

    /**
     * @param value A short, machine-readable name for the application. This can only be defined on resource creation and ignored on resource update.
     */
    @JvmName("ybvvtdslxywgawgt")
    public suspend fun shortName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shortName = mapped
    }

    /**
     * @param value The SSL configuration of the app. Object is described below.
     */
    @JvmName("fttrggjgtakonpqp")
    public suspend fun sslConfigurations(`value`: List<ApplicationSslConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslConfigurations = mapped
    }

    /**
     * @param argument The SSL configuration of the app. Object is described below.
     */
    @JvmName("fiaeshuhdcuxbibs")
    public suspend fun sslConfigurations(argument: List<suspend ApplicationSslConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationSslConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sslConfigurations = mapped
    }

    /**
     * @param argument The SSL configuration of the app. Object is described below.
     */
    @JvmName("llntdvffqjjgpfsj")
    public suspend fun sslConfigurations(vararg argument: suspend ApplicationSslConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ApplicationSslConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sslConfigurations = mapped
    }

    /**
     * @param argument The SSL configuration of the app. Object is described below.
     */
    @JvmName("ysqjrumbhbhiwlbs")
    public suspend fun sslConfigurations(argument: suspend ApplicationSslConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationSslConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.sslConfigurations = mapped
    }

    /**
     * @param values The SSL configuration of the app. Object is described below.
     */
    @JvmName("mcqtyiieolqvigrp")
    public suspend fun sslConfigurations(vararg values: ApplicationSslConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sslConfigurations = mapped
    }

    /**
     * @param value ID of the stack the application will belong to.
     */
    @JvmName("lcqktiiyqnjhnkux")
    public suspend fun stackId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stackId = mapped
    }

    /**
     * @param value Opsworks application type. One of `aws-flow-ruby`, `java`, `rails`, `php`, `nodejs`, `static` or `other`.
     */
    @JvmName("xbyhlaeyavxelveu")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ApplicationArgs = ApplicationArgs(
        appSources = appSources,
        autoBundleOnDeploy = autoBundleOnDeploy,
        awsFlowRubySettings = awsFlowRubySettings,
        dataSourceArn = dataSourceArn,
        dataSourceDatabaseName = dataSourceDatabaseName,
        dataSourceType = dataSourceType,
        description = description,
        documentRoot = documentRoot,
        domains = domains,
        enableSsl = enableSsl,
        environments = environments,
        name = name,
        railsEnv = railsEnv,
        shortName = shortName,
        sslConfigurations = sslConfigurations,
        stackId = stackId,
        type = type,
    )
}
