@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin

import com.pulumi.aws.opsworks.InstanceArgs.builder
import com.pulumi.aws.opsworks.kotlin.inputs.InstanceEbsBlockDeviceArgs
import com.pulumi.aws.opsworks.kotlin.inputs.InstanceEbsBlockDeviceArgsBuilder
import com.pulumi.aws.opsworks.kotlin.inputs.InstanceEphemeralBlockDeviceArgs
import com.pulumi.aws.opsworks.kotlin.inputs.InstanceEphemeralBlockDeviceArgsBuilder
import com.pulumi.aws.opsworks.kotlin.inputs.InstanceRootBlockDeviceArgs
import com.pulumi.aws.opsworks.kotlin.inputs.InstanceRootBlockDeviceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an OpsWorks instance resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const my_instance = new aws.opsworks.Instance("my-instance", {
 *     stackId: main.id,
 *     layerIds: [my_layer&#46;id],
 *     instanceType: "t2.micro",
 *     os: "Amazon Linux 2015.09",
 *     state: "stopped",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * my_instance = aws.opsworks.Instance("my-instance",
 *     stack_id=main["id"],
 *     layer_ids=[my_layer["id"]],
 *     instance_type="t2.micro",
 *     os="Amazon Linux 2015.09",
 *     state="stopped")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var my_instance = new Aws.OpsWorks.Instance("my-instance", new()
 *     {
 *         StackId = main.Id,
 *         LayerIds = new[]
 *         {
 *             my_layer.Id,
 *         },
 *         InstanceType = "t2.micro",
 *         Os = "Amazon Linux 2015.09",
 *         State = "stopped",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/opsworks"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := opsworks.NewInstance(ctx, "my-instance", &opsworks.InstanceArgs{
 * 			StackId: pulumi.Any(main.Id),
 * 			LayerIds: pulumi.StringArray{
 * 				my_layer.Id,
 * 			},
 * 			InstanceType: pulumi.String("t2.micro"),
 * 			Os:           pulumi.String("Amazon Linux 2015.09"),
 * 			State:        pulumi.String("stopped"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opsworks.Instance;
 * import com.pulumi.aws.opsworks.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var my_instance = new Instance("my-instance", InstanceArgs.builder()
 *             .stackId(main.id())
 *             .layerIds(my_layer.id())
 *             .instanceType("t2.micro")
 *             .os("Amazon Linux 2015.09")
 *             .state("stopped")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   my-instance:
 *     type: aws:opsworks:Instance
 *     properties:
 *       stackId: ${main.id}
 *       layerIds:
 *         - ${["my-layer"].id}
 *       instanceType: t2.micro
 *       os: Amazon Linux 2015.09
 *       state: stopped
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Block devices
 * Each of the `*_block_device` attributes controls a portion of the AWS
 * Instance's "Block Device Mapping". It's a good idea to familiarize yourself with [AWS's Block Device
 * Mapping docs](http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html)
 * to understand the implications of using these attributes.
 * ### `ebs_block_device`
 * * `delete_on_termination` - (Optional) Whether the volume should be destroyed on instance termination. Default is `true`.
 * * `device_name` - (Required) Name of the device to mount.
 * * `iops` - (Optional) Amount of provisioned [IOPS](http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-io-characteristics.html). This must be set with a `volume_type` of `io1`.
 * * `snapshot_id` - (Optional) Snapshot ID to mount.
 * * `volume_size` - (Optional) Size of the volume in gigabytes.
 * * `volume_type` - (Optional) Type of volume. Valid values are `standard`, `gp2`, or `io1`. Default is `standard`.
 * Modifying any `ebs_block_device` currently requires resource replacement.
 * ### `ephemeral_block_device`
 * * `device_name` - Name of the block device to mount on the instance.
 * * `virtual_name` - The [Instance Store Device Name](http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#InstanceStoreDeviceNames) (e.g., `ephemeral0`).
 * Each AWS Instance type has a different set of Instance Store block devices
 * available for attachment. AWS [publishes a
 * list](http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#StorageOnInstanceTypes)
 * of which ephemeral devices are available on each type. The devices are always
 * identified by the `virtual_name` in the format `ephemeral{0..N}`.
 * ### `root_block_device`
 * * `delete_on_termination` - (Optional) Whether the volume should be destroyed on instance termination. Default is `true`.
 * * `iops` - (Optional) Amount of provisioned [IOPS](http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-io-characteristics.html). This must be set with a `volume_type` of `io1`.
 * * `volume_size` - (Optional) Size of the volume in gigabytes.
 * * `volume_type` - (Optional) Type of volume. Valid values are `standard`, `gp2`, or `io1`. Default is `standard`.
 * Modifying any of the `root_block_device` settings requires resource
 * replacement.
 * > **NOTE:** Currently, changes to `*_block_device` configuration of _existing_
 * resources cannot be automatically detected by this provider. After making updates
 * to block device configuration, resource recreation can be manually triggered by
 * using the [`up` command with the --replace argument](https://www.pulumi.com/docs/reference/cli/pulumi_up/).
 * ## Import
 * Using `pulumi import`, import Opsworks Instances using the instance `id`. For example:
 * ```sh
 * $ pulumi import aws:opsworks/instance:Instance my_instance 4d6d1710-ded9-42a1-b08e-b043ad7af1e2
 * ```
 * @property agentVersion OpsWorks agent to install. Default is `INHERIT`.
 * @property amiId AMI to use for the instance.  If an AMI is specified, `os` must be `Custom`.
 * @property architecture Machine architecture for created instances.  Valid values are `x86_64` or `i386`. The default is `x86_64`.
 * @property autoScalingType Creates load-based or time-based instances.  Valid values are `load`, `timer`.
 * @property availabilityZone Name of the availability zone where instances will be created by default.
 * @property createdAt Time that the instance was created.
 * @property deleteEbs Whether to delete EBS volume on deletion. Default is `true`.
 * @property deleteEip Whether to delete the Elastic IP on deletion.
 * @property ebsBlockDevices Configuration block for additional EBS block devices to attach to the instance. See Block Devices below.
 * @property ebsOptimized Whether the launched EC2 instance will be EBS-optimized.
 * @property ecsClusterArn ECS cluster's ARN for container instances.
 * @property elasticIp Instance Elastic IP address.
 * @property ephemeralBlockDevices Configuration block for ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below.
 * @property hostname Instance's host name.
 * @property infrastructureClass For registered instances, infrastructure class: ec2 or on-premises.
 * @property installUpdatesOnBoot Controls where to install OS and package updates when the instance boots.  Default is `true`.
 * @property instanceProfileArn ARN of the instance's IAM profile.
 * @property instanceType Type of instance to start.
 * @property layerIds List of the layers the instance will belong to.
 * @property os Name of operating system that will be installed.
 * @property rootBlockDevices Configuration block for the root block device of the instance. See Block Devices below.
 * @property rootDeviceType Name of the type of root device instances will have by default. Valid values are `ebs` or `instance-store`.
 * @property securityGroupIds Associated security groups.
 * @property sshKeyName Name of the SSH keypair that instances will have by default.
 * @property stackId Identifier of the stack the instance will belong to.
 * The following arguments are optional:
 * @property state Desired state of the instance. Valid values are `running` or `stopped`.
 * @property status Instance status. Will be one of `booting`, `connection_lost`, `online`, `pending`, `rebooting`, `requested`, `running_setup`, `setup_failed`, `shutting_down`, `start_failed`, `stop_failed`, `stopped`, `stopping`, `terminated`, or `terminating`.
 * @property subnetId Subnet ID to attach to.
 * @property tenancy Instance tenancy to use. Valid values are `default`, `dedicated` or `host`.
 * @property virtualizationType Keyword to choose what virtualization mode created instances will use. Valid values are `paravirtual` or `hvm`.
 */
public data class InstanceArgs(
    public val agentVersion: Output<String>? = null,
    public val amiId: Output<String>? = null,
    public val architecture: Output<String>? = null,
    public val autoScalingType: Output<String>? = null,
    public val availabilityZone: Output<String>? = null,
    public val createdAt: Output<String>? = null,
    public val deleteEbs: Output<Boolean>? = null,
    public val deleteEip: Output<Boolean>? = null,
    public val ebsBlockDevices: Output<List<InstanceEbsBlockDeviceArgs>>? = null,
    public val ebsOptimized: Output<Boolean>? = null,
    public val ecsClusterArn: Output<String>? = null,
    public val elasticIp: Output<String>? = null,
    public val ephemeralBlockDevices: Output<List<InstanceEphemeralBlockDeviceArgs>>? = null,
    public val hostname: Output<String>? = null,
    public val infrastructureClass: Output<String>? = null,
    public val installUpdatesOnBoot: Output<Boolean>? = null,
    public val instanceProfileArn: Output<String>? = null,
    public val instanceType: Output<String>? = null,
    public val layerIds: Output<List<String>>? = null,
    public val os: Output<String>? = null,
    public val rootBlockDevices: Output<List<InstanceRootBlockDeviceArgs>>? = null,
    public val rootDeviceType: Output<String>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val sshKeyName: Output<String>? = null,
    public val stackId: Output<String>? = null,
    public val state: Output<String>? = null,
    public val status: Output<String>? = null,
    public val subnetId: Output<String>? = null,
    public val tenancy: Output<String>? = null,
    public val virtualizationType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.opsworks.InstanceArgs> {
    override fun toJava(): com.pulumi.aws.opsworks.InstanceArgs =
        com.pulumi.aws.opsworks.InstanceArgs.builder()
            .agentVersion(agentVersion?.applyValue({ args0 -> args0 }))
            .amiId(amiId?.applyValue({ args0 -> args0 }))
            .architecture(architecture?.applyValue({ args0 -> args0 }))
            .autoScalingType(autoScalingType?.applyValue({ args0 -> args0 }))
            .availabilityZone(availabilityZone?.applyValue({ args0 -> args0 }))
            .createdAt(createdAt?.applyValue({ args0 -> args0 }))
            .deleteEbs(deleteEbs?.applyValue({ args0 -> args0 }))
            .deleteEip(deleteEip?.applyValue({ args0 -> args0 }))
            .ebsBlockDevices(
                ebsBlockDevices?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ebsOptimized(ebsOptimized?.applyValue({ args0 -> args0 }))
            .ecsClusterArn(ecsClusterArn?.applyValue({ args0 -> args0 }))
            .elasticIp(elasticIp?.applyValue({ args0 -> args0 }))
            .ephemeralBlockDevices(
                ephemeralBlockDevices?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .hostname(hostname?.applyValue({ args0 -> args0 }))
            .infrastructureClass(infrastructureClass?.applyValue({ args0 -> args0 }))
            .installUpdatesOnBoot(installUpdatesOnBoot?.applyValue({ args0 -> args0 }))
            .instanceProfileArn(instanceProfileArn?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .layerIds(layerIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .os(os?.applyValue({ args0 -> args0 }))
            .rootBlockDevices(
                rootBlockDevices?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .rootDeviceType(rootDeviceType?.applyValue({ args0 -> args0 }))
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sshKeyName(sshKeyName?.applyValue({ args0 -> args0 }))
            .stackId(stackId?.applyValue({ args0 -> args0 }))
            .state(state?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 }))
            .tenancy(tenancy?.applyValue({ args0 -> args0 }))
            .virtualizationType(virtualizationType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceArgs].
 */
@PulumiTagMarker
public class InstanceArgsBuilder internal constructor() {
    private var agentVersion: Output<String>? = null

    private var amiId: Output<String>? = null

    private var architecture: Output<String>? = null

    private var autoScalingType: Output<String>? = null

    private var availabilityZone: Output<String>? = null

    private var createdAt: Output<String>? = null

    private var deleteEbs: Output<Boolean>? = null

    private var deleteEip: Output<Boolean>? = null

    private var ebsBlockDevices: Output<List<InstanceEbsBlockDeviceArgs>>? = null

    private var ebsOptimized: Output<Boolean>? = null

    private var ecsClusterArn: Output<String>? = null

    private var elasticIp: Output<String>? = null

    private var ephemeralBlockDevices: Output<List<InstanceEphemeralBlockDeviceArgs>>? = null

    private var hostname: Output<String>? = null

    private var infrastructureClass: Output<String>? = null

    private var installUpdatesOnBoot: Output<Boolean>? = null

    private var instanceProfileArn: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var layerIds: Output<List<String>>? = null

    private var os: Output<String>? = null

    private var rootBlockDevices: Output<List<InstanceRootBlockDeviceArgs>>? = null

    private var rootDeviceType: Output<String>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var sshKeyName: Output<String>? = null

    private var stackId: Output<String>? = null

    private var state: Output<String>? = null

    private var status: Output<String>? = null

    private var subnetId: Output<String>? = null

    private var tenancy: Output<String>? = null

    private var virtualizationType: Output<String>? = null

    /**
     * @param value OpsWorks agent to install. Default is `INHERIT`.
     */
    @JvmName("cuscykvpwbjkjdsn")
    public suspend fun agentVersion(`value`: Output<String>) {
        this.agentVersion = value
    }

    /**
     * @param value AMI to use for the instance.  If an AMI is specified, `os` must be `Custom`.
     */
    @JvmName("ghgrwmpmahywausd")
    public suspend fun amiId(`value`: Output<String>) {
        this.amiId = value
    }

    /**
     * @param value Machine architecture for created instances.  Valid values are `x86_64` or `i386`. The default is `x86_64`.
     */
    @JvmName("iabduhwgnlqeablf")
    public suspend fun architecture(`value`: Output<String>) {
        this.architecture = value
    }

    /**
     * @param value Creates load-based or time-based instances.  Valid values are `load`, `timer`.
     */
    @JvmName("pkqvmyqpnrplgequ")
    public suspend fun autoScalingType(`value`: Output<String>) {
        this.autoScalingType = value
    }

    /**
     * @param value Name of the availability zone where instances will be created by default.
     */
    @JvmName("hdaflckhawdxqgqc")
    public suspend fun availabilityZone(`value`: Output<String>) {
        this.availabilityZone = value
    }

    /**
     * @param value Time that the instance was created.
     */
    @JvmName("grecikdkxiqscocc")
    public suspend fun createdAt(`value`: Output<String>) {
        this.createdAt = value
    }

    /**
     * @param value Whether to delete EBS volume on deletion. Default is `true`.
     */
    @JvmName("owhcnsyfsjamynpr")
    public suspend fun deleteEbs(`value`: Output<Boolean>) {
        this.deleteEbs = value
    }

    /**
     * @param value Whether to delete the Elastic IP on deletion.
     */
    @JvmName("nksrpypxymfhecvr")
    public suspend fun deleteEip(`value`: Output<Boolean>) {
        this.deleteEip = value
    }

    /**
     * @param value Configuration block for additional EBS block devices to attach to the instance. See Block Devices below.
     */
    @JvmName("lgkhycmjjmqrdpgk")
    public suspend fun ebsBlockDevices(`value`: Output<List<InstanceEbsBlockDeviceArgs>>) {
        this.ebsBlockDevices = value
    }

    @JvmName("avqslmhwddgmpabg")
    public suspend fun ebsBlockDevices(vararg values: Output<InstanceEbsBlockDeviceArgs>) {
        this.ebsBlockDevices = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for additional EBS block devices to attach to the instance. See Block Devices below.
     */
    @JvmName("petqokhnmtkjpnvg")
    public suspend fun ebsBlockDevices(values: List<Output<InstanceEbsBlockDeviceArgs>>) {
        this.ebsBlockDevices = Output.all(values)
    }

    /**
     * @param value Whether the launched EC2 instance will be EBS-optimized.
     */
    @JvmName("gjmpmkxvsybujcxq")
    public suspend fun ebsOptimized(`value`: Output<Boolean>) {
        this.ebsOptimized = value
    }

    /**
     * @param value ECS cluster's ARN for container instances.
     */
    @JvmName("grjfwvwpcknveify")
    public suspend fun ecsClusterArn(`value`: Output<String>) {
        this.ecsClusterArn = value
    }

    /**
     * @param value Instance Elastic IP address.
     */
    @JvmName("hiibwlofqpunawje")
    public suspend fun elasticIp(`value`: Output<String>) {
        this.elasticIp = value
    }

    /**
     * @param value Configuration block for ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below.
     */
    @JvmName("tsrtcyqctjlnkngr")
    public suspend fun ephemeralBlockDevices(`value`: Output<List<InstanceEphemeralBlockDeviceArgs>>) {
        this.ephemeralBlockDevices = value
    }

    @JvmName("qbykweybxfhxnffg")
    public suspend fun ephemeralBlockDevices(vararg values: Output<InstanceEphemeralBlockDeviceArgs>) {
        this.ephemeralBlockDevices = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below.
     */
    @JvmName("xwjorkjxneqemilq")
    public suspend fun ephemeralBlockDevices(values: List<Output<InstanceEphemeralBlockDeviceArgs>>) {
        this.ephemeralBlockDevices = Output.all(values)
    }

    /**
     * @param value Instance's host name.
     */
    @JvmName("dolygcyyhbbxxqrq")
    public suspend fun hostname(`value`: Output<String>) {
        this.hostname = value
    }

    /**
     * @param value For registered instances, infrastructure class: ec2 or on-premises.
     */
    @JvmName("jnssqrbupucmqcpl")
    public suspend fun infrastructureClass(`value`: Output<String>) {
        this.infrastructureClass = value
    }

    /**
     * @param value Controls where to install OS and package updates when the instance boots.  Default is `true`.
     */
    @JvmName("txtokoibbnjmqfik")
    public suspend fun installUpdatesOnBoot(`value`: Output<Boolean>) {
        this.installUpdatesOnBoot = value
    }

    /**
     * @param value ARN of the instance's IAM profile.
     */
    @JvmName("tdotwcojcndxpgsj")
    public suspend fun instanceProfileArn(`value`: Output<String>) {
        this.instanceProfileArn = value
    }

    /**
     * @param value Type of instance to start.
     */
    @JvmName("witjllftoyidxmii")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value List of the layers the instance will belong to.
     */
    @JvmName("vbggqiohnqednjly")
    public suspend fun layerIds(`value`: Output<List<String>>) {
        this.layerIds = value
    }

    @JvmName("kxxtjwadoknylfwi")
    public suspend fun layerIds(vararg values: Output<String>) {
        this.layerIds = Output.all(values.asList())
    }

    /**
     * @param values List of the layers the instance will belong to.
     */
    @JvmName("aicnvslxcyjhmvif")
    public suspend fun layerIds(values: List<Output<String>>) {
        this.layerIds = Output.all(values)
    }

    /**
     * @param value Name of operating system that will be installed.
     */
    @JvmName("wwumiqkrdoqykbfg")
    public suspend fun os(`value`: Output<String>) {
        this.os = value
    }

    /**
     * @param value Configuration block for the root block device of the instance. See Block Devices below.
     */
    @JvmName("kkxwwiwjnbbnhoke")
    public suspend fun rootBlockDevices(`value`: Output<List<InstanceRootBlockDeviceArgs>>) {
        this.rootBlockDevices = value
    }

    @JvmName("lqvryabnigmdemvj")
    public suspend fun rootBlockDevices(vararg values: Output<InstanceRootBlockDeviceArgs>) {
        this.rootBlockDevices = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for the root block device of the instance. See Block Devices below.
     */
    @JvmName("qgrsiwgpdubgdfej")
    public suspend fun rootBlockDevices(values: List<Output<InstanceRootBlockDeviceArgs>>) {
        this.rootBlockDevices = Output.all(values)
    }

    /**
     * @param value Name of the type of root device instances will have by default. Valid values are `ebs` or `instance-store`.
     */
    @JvmName("ltgntfljetpdnlrt")
    public suspend fun rootDeviceType(`value`: Output<String>) {
        this.rootDeviceType = value
    }

    /**
     * @param value Associated security groups.
     */
    @JvmName("ssevddwwtayvrknl")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("clxxirpgfaewcgqp")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values Associated security groups.
     */
    @JvmName("brmyiodkvndgqvng")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value Name of the SSH keypair that instances will have by default.
     */
    @JvmName("hpjbxdnaugehgarm")
    public suspend fun sshKeyName(`value`: Output<String>) {
        this.sshKeyName = value
    }

    /**
     * @param value Identifier of the stack the instance will belong to.
     * The following arguments are optional:
     */
    @JvmName("hggbaiyaxeaduimw")
    public suspend fun stackId(`value`: Output<String>) {
        this.stackId = value
    }

    /**
     * @param value Desired state of the instance. Valid values are `running` or `stopped`.
     */
    @JvmName("jrprcsclneujvbmt")
    public suspend fun state(`value`: Output<String>) {
        this.state = value
    }

    /**
     * @param value Instance status. Will be one of `booting`, `connection_lost`, `online`, `pending`, `rebooting`, `requested`, `running_setup`, `setup_failed`, `shutting_down`, `start_failed`, `stop_failed`, `stopped`, `stopping`, `terminated`, or `terminating`.
     */
    @JvmName("kbioxrianiidqaak")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Subnet ID to attach to.
     */
    @JvmName("iawvpjqmxmptjqju")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value Instance tenancy to use. Valid values are `default`, `dedicated` or `host`.
     */
    @JvmName("cwqyhuucifcepqtt")
    public suspend fun tenancy(`value`: Output<String>) {
        this.tenancy = value
    }

    /**
     * @param value Keyword to choose what virtualization mode created instances will use. Valid values are `paravirtual` or `hvm`.
     */
    @JvmName("ieyptfiuhkvyclsw")
    public suspend fun virtualizationType(`value`: Output<String>) {
        this.virtualizationType = value
    }

    /**
     * @param value OpsWorks agent to install. Default is `INHERIT`.
     */
    @JvmName("inbjwkdlikbjeako")
    public suspend fun agentVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentVersion = mapped
    }

    /**
     * @param value AMI to use for the instance.  If an AMI is specified, `os` must be `Custom`.
     */
    @JvmName("yjwmnshiwsuvkhhr")
    public suspend fun amiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amiId = mapped
    }

    /**
     * @param value Machine architecture for created instances.  Valid values are `x86_64` or `i386`. The default is `x86_64`.
     */
    @JvmName("jpskbpjvmuasvxcg")
    public suspend fun architecture(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.architecture = mapped
    }

    /**
     * @param value Creates load-based or time-based instances.  Valid values are `load`, `timer`.
     */
    @JvmName("wgxvlknpqvpwrsrr")
    public suspend fun autoScalingType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoScalingType = mapped
    }

    /**
     * @param value Name of the availability zone where instances will be created by default.
     */
    @JvmName("ygdjuncdkdpcdsqk")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZone = mapped
    }

    /**
     * @param value Time that the instance was created.
     */
    @JvmName("tybyevbrnrjdkrpy")
    public suspend fun createdAt(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createdAt = mapped
    }

    /**
     * @param value Whether to delete EBS volume on deletion. Default is `true`.
     */
    @JvmName("ctmjbodxkjnjyshg")
    public suspend fun deleteEbs(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteEbs = mapped
    }

    /**
     * @param value Whether to delete the Elastic IP on deletion.
     */
    @JvmName("oglrfhxsqsnafpls")
    public suspend fun deleteEip(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteEip = mapped
    }

    /**
     * @param value Configuration block for additional EBS block devices to attach to the instance. See Block Devices below.
     */
    @JvmName("bydpmofrtkntxmag")
    public suspend fun ebsBlockDevices(`value`: List<InstanceEbsBlockDeviceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebsBlockDevices = mapped
    }

    /**
     * @param argument Configuration block for additional EBS block devices to attach to the instance. See Block Devices below.
     */
    @JvmName("dfxqykipmbvhxuee")
    public suspend fun ebsBlockDevices(argument: List<suspend InstanceEbsBlockDeviceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InstanceEbsBlockDeviceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ebsBlockDevices = mapped
    }

    /**
     * @param argument Configuration block for additional EBS block devices to attach to the instance. See Block Devices below.
     */
    @JvmName("xbeubggufkbkwymx")
    public suspend fun ebsBlockDevices(vararg argument: suspend InstanceEbsBlockDeviceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InstanceEbsBlockDeviceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ebsBlockDevices = mapped
    }

    /**
     * @param argument Configuration block for additional EBS block devices to attach to the instance. See Block Devices below.
     */
    @JvmName("yqhlfkgqhwxelglw")
    public suspend fun ebsBlockDevices(argument: suspend InstanceEbsBlockDeviceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InstanceEbsBlockDeviceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ebsBlockDevices = mapped
    }

    /**
     * @param values Configuration block for additional EBS block devices to attach to the instance. See Block Devices below.
     */
    @JvmName("fcqpcthbqygnmeqi")
    public suspend fun ebsBlockDevices(vararg values: InstanceEbsBlockDeviceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ebsBlockDevices = mapped
    }

    /**
     * @param value Whether the launched EC2 instance will be EBS-optimized.
     */
    @JvmName("vuqonqlrlvleqser")
    public suspend fun ebsOptimized(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebsOptimized = mapped
    }

    /**
     * @param value ECS cluster's ARN for container instances.
     */
    @JvmName("vadfaojmhumpxttq")
    public suspend fun ecsClusterArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ecsClusterArn = mapped
    }

    /**
     * @param value Instance Elastic IP address.
     */
    @JvmName("nnfmiariamstxbie")
    public suspend fun elasticIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticIp = mapped
    }

    /**
     * @param value Configuration block for ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below.
     */
    @JvmName("icrcgrnnvxbtfajw")
    public suspend fun ephemeralBlockDevices(`value`: List<InstanceEphemeralBlockDeviceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param argument Configuration block for ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below.
     */
    @JvmName("hauvlxokppogekgw")
    public suspend fun ephemeralBlockDevices(argument: List<suspend InstanceEphemeralBlockDeviceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InstanceEphemeralBlockDeviceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param argument Configuration block for ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below.
     */
    @JvmName("hfmaapxaffiikhxo")
    public suspend fun ephemeralBlockDevices(vararg argument: suspend InstanceEphemeralBlockDeviceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InstanceEphemeralBlockDeviceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param argument Configuration block for ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below.
     */
    @JvmName("pfsskiqqwwpisnqv")
    public suspend fun ephemeralBlockDevices(argument: suspend InstanceEphemeralBlockDeviceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InstanceEphemeralBlockDeviceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param values Configuration block for ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below.
     */
    @JvmName("vnlaswmtuorkkcve")
    public suspend fun ephemeralBlockDevices(vararg values: InstanceEphemeralBlockDeviceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param value Instance's host name.
     */
    @JvmName("bpwcfmjoavcqvwle")
    public suspend fun hostname(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostname = mapped
    }

    /**
     * @param value For registered instances, infrastructure class: ec2 or on-premises.
     */
    @JvmName("cjroxlnnrvpcvecn")
    public suspend fun infrastructureClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.infrastructureClass = mapped
    }

    /**
     * @param value Controls where to install OS and package updates when the instance boots.  Default is `true`.
     */
    @JvmName("rvbekylsorkshhhq")
    public suspend fun installUpdatesOnBoot(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.installUpdatesOnBoot = mapped
    }

    /**
     * @param value ARN of the instance's IAM profile.
     */
    @JvmName("lbdrafupbnxxdhnn")
    public suspend fun instanceProfileArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceProfileArn = mapped
    }

    /**
     * @param value Type of instance to start.
     */
    @JvmName("dgvxtkfjoacilkhf")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value List of the layers the instance will belong to.
     */
    @JvmName("qcjnidxxtekxwmxe")
    public suspend fun layerIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.layerIds = mapped
    }

    /**
     * @param values List of the layers the instance will belong to.
     */
    @JvmName("qeomktswpdunxati")
    public suspend fun layerIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.layerIds = mapped
    }

    /**
     * @param value Name of operating system that will be installed.
     */
    @JvmName("cdpssjbdvdlldogx")
    public suspend fun os(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.os = mapped
    }

    /**
     * @param value Configuration block for the root block device of the instance. See Block Devices below.
     */
    @JvmName("yettsftkcgfokpfy")
    public suspend fun rootBlockDevices(`value`: List<InstanceRootBlockDeviceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rootBlockDevices = mapped
    }

    /**
     * @param argument Configuration block for the root block device of the instance. See Block Devices below.
     */
    @JvmName("ruflscywikxsyeul")
    public suspend fun rootBlockDevices(argument: List<suspend InstanceRootBlockDeviceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InstanceRootBlockDeviceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rootBlockDevices = mapped
    }

    /**
     * @param argument Configuration block for the root block device of the instance. See Block Devices below.
     */
    @JvmName("qlhfypapcgbeyijc")
    public suspend fun rootBlockDevices(vararg argument: suspend InstanceRootBlockDeviceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InstanceRootBlockDeviceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rootBlockDevices = mapped
    }

    /**
     * @param argument Configuration block for the root block device of the instance. See Block Devices below.
     */
    @JvmName("pioolccukerditdf")
    public suspend fun rootBlockDevices(argument: suspend InstanceRootBlockDeviceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InstanceRootBlockDeviceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.rootBlockDevices = mapped
    }

    /**
     * @param values Configuration block for the root block device of the instance. See Block Devices below.
     */
    @JvmName("bhkjlsogiovnhlpv")
    public suspend fun rootBlockDevices(vararg values: InstanceRootBlockDeviceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rootBlockDevices = mapped
    }

    /**
     * @param value Name of the type of root device instances will have by default. Valid values are `ebs` or `instance-store`.
     */
    @JvmName("eoqnwbjldhgxtbus")
    public suspend fun rootDeviceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rootDeviceType = mapped
    }

    /**
     * @param value Associated security groups.
     */
    @JvmName("nutxskcqarhdxdue")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values Associated security groups.
     */
    @JvmName("lpkfagtdsflnajog")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value Name of the SSH keypair that instances will have by default.
     */
    @JvmName("nnawatuttockugyj")
    public suspend fun sshKeyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sshKeyName = mapped
    }

    /**
     * @param value Identifier of the stack the instance will belong to.
     * The following arguments are optional:
     */
    @JvmName("hkgyxgbcnweocxmp")
    public suspend fun stackId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stackId = mapped
    }

    /**
     * @param value Desired state of the instance. Valid values are `running` or `stopped`.
     */
    @JvmName("klhpamobjgrqfygm")
    public suspend fun state(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Instance status. Will be one of `booting`, `connection_lost`, `online`, `pending`, `rebooting`, `requested`, `running_setup`, `setup_failed`, `shutting_down`, `start_failed`, `stop_failed`, `stopped`, `stopping`, `terminated`, or `terminating`.
     */
    @JvmName("fenoqahraokviscp")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Subnet ID to attach to.
     */
    @JvmName("dkbxjdsmylwboplt")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    /**
     * @param value Instance tenancy to use. Valid values are `default`, `dedicated` or `host`.
     */
    @JvmName("icuqifgvljmqgknc")
    public suspend fun tenancy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenancy = mapped
    }

    /**
     * @param value Keyword to choose what virtualization mode created instances will use. Valid values are `paravirtual` or `hvm`.
     */
    @JvmName("lmdaakieueywjlav")
    public suspend fun virtualizationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualizationType = mapped
    }

    internal fun build(): InstanceArgs = InstanceArgs(
        agentVersion = agentVersion,
        amiId = amiId,
        architecture = architecture,
        autoScalingType = autoScalingType,
        availabilityZone = availabilityZone,
        createdAt = createdAt,
        deleteEbs = deleteEbs,
        deleteEip = deleteEip,
        ebsBlockDevices = ebsBlockDevices,
        ebsOptimized = ebsOptimized,
        ecsClusterArn = ecsClusterArn,
        elasticIp = elasticIp,
        ephemeralBlockDevices = ephemeralBlockDevices,
        hostname = hostname,
        infrastructureClass = infrastructureClass,
        installUpdatesOnBoot = installUpdatesOnBoot,
        instanceProfileArn = instanceProfileArn,
        instanceType = instanceType,
        layerIds = layerIds,
        os = os,
        rootBlockDevices = rootBlockDevices,
        rootDeviceType = rootDeviceType,
        securityGroupIds = securityGroupIds,
        sshKeyName = sshKeyName,
        stackId = stackId,
        state = state,
        status = status,
        subnetId = subnetId,
        tenancy = tenancy,
        virtualizationType = virtualizationType,
    )
}
