@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin

import com.pulumi.aws.opsworks.kotlin.outputs.MemcachedLayerCloudwatchConfiguration
import com.pulumi.aws.opsworks.kotlin.outputs.MemcachedLayerEbsVolume
import com.pulumi.aws.opsworks.kotlin.outputs.MemcachedLayerLoadBasedAutoScaling
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.opsworks.kotlin.outputs.MemcachedLayerCloudwatchConfiguration.Companion.toKotlin as memcachedLayerCloudwatchConfigurationToKotlin
import com.pulumi.aws.opsworks.kotlin.outputs.MemcachedLayerEbsVolume.Companion.toKotlin as memcachedLayerEbsVolumeToKotlin
import com.pulumi.aws.opsworks.kotlin.outputs.MemcachedLayerLoadBasedAutoScaling.Companion.toKotlin as memcachedLayerLoadBasedAutoScalingToKotlin

/**
 * Builder for [MemcachedLayer].
 */
@PulumiTagMarker
public class MemcachedLayerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MemcachedLayerArgs = MemcachedLayerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MemcachedLayerArgsBuilder.() -> Unit) {
        val builder = MemcachedLayerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MemcachedLayer {
        val builtJavaResource = com.pulumi.aws.opsworks.MemcachedLayer(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MemcachedLayer(builtJavaResource)
    }
}

/**
 * Provides an OpsWorks memcached layer resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const cache = new aws.opsworks.MemcachedLayer("cache", {stackId: main.id});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * cache = aws.opsworks.MemcachedLayer("cache", stack_id=main["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cache = new Aws.OpsWorks.MemcachedLayer("cache", new()
 *     {
 *         StackId = main.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/opsworks"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := opsworks.NewMemcachedLayer(ctx, "cache", &opsworks.MemcachedLayerArgs{
 * 			StackId: pulumi.Any(main.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opsworks.MemcachedLayer;
 * import com.pulumi.aws.opsworks.MemcachedLayerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cache = new MemcachedLayer("cache", MemcachedLayerArgs.builder()
 *             .stackId(main.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   cache:
 *     type: aws:opsworks:MemcachedLayer
 *     properties:
 *       stackId: ${main.id}
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class MemcachedLayer internal constructor(
    override val javaResource: com.pulumi.aws.opsworks.MemcachedLayer,
) : KotlinCustomResource(javaResource, MemcachedLayerMapper) {
    /**
     * Amount of memory to allocate for the cache on each instance, in megabytes. Defaults to 512MB.
     */
    public val allocatedMemory: Output<Int>?
        get() = javaResource.allocatedMemory().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Amazon Resource Name(ARN) of the layer.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Whether to automatically assign an elastic IP address to the layer's instances.
     */
    public val autoAssignElasticIps: Output<Boolean>?
        get() = javaResource.autoAssignElasticIps().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * For stacks belonging to a VPC, whether to automatically assign a public IP address to each of the layer's instances.
     */
    public val autoAssignPublicIps: Output<Boolean>?
        get() = javaResource.autoAssignPublicIps().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to enable auto-healing for the layer.
     */
    public val autoHealing: Output<Boolean>?
        get() = javaResource.autoHealing().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val cloudwatchConfiguration: Output<MemcachedLayerCloudwatchConfiguration>?
        get() = javaResource.cloudwatchConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> memcachedLayerCloudwatchConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    public val customConfigureRecipes: Output<List<String>>?
        get() = javaResource.customConfigureRecipes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    public val customDeployRecipes: Output<List<String>>?
        get() = javaResource.customDeployRecipes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The ARN of an IAM profile that will be used for the layer's instances.
     */
    public val customInstanceProfileArn: Output<String>?
        get() = javaResource.customInstanceProfileArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Custom JSON attributes to apply to the layer.
     */
    public val customJson: Output<String>?
        get() = javaResource.customJson().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Ids for a set of security groups to apply to the layer's instances.
     */
    public val customSecurityGroupIds: Output<List<String>>?
        get() = javaResource.customSecurityGroupIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    public val customSetupRecipes: Output<List<String>>?
        get() = javaResource.customSetupRecipes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    public val customShutdownRecipes: Output<List<String>>?
        get() = javaResource.customShutdownRecipes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    public val customUndeployRecipes: Output<List<String>>?
        get() = javaResource.customUndeployRecipes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Whether to enable Elastic Load Balancing connection draining.
     */
    public val drainElbOnShutdown: Output<Boolean>?
        get() = javaResource.drainElbOnShutdown().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
     */
    public val ebsVolumes: Output<List<MemcachedLayerEbsVolume>>
        get() = javaResource.ebsVolumes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    memcachedLayerEbsVolumeToKotlin(args0)
                })
            })
        })

    /**
     * Name of an Elastic Load Balancer to attach to this layer
     */
    public val elasticLoadBalancer: Output<String>?
        get() = javaResource.elasticLoadBalancer().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to install OS and package updates on each instance when it boots.
     */
    public val installUpdatesOnBoot: Output<Boolean>?
        get() = javaResource.installUpdatesOnBoot().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The time, in seconds, that OpsWorks will wait for Chef to complete after triggering the Shutdown event.
     */
    public val instanceShutdownTimeout: Output<Int>?
        get() = javaResource.instanceShutdownTimeout().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val loadBasedAutoScaling: Output<MemcachedLayerLoadBasedAutoScaling>
        get() = javaResource.loadBasedAutoScaling().applyValue({ args0 ->
            args0.let({ args0 ->
                memcachedLayerLoadBasedAutoScalingToKotlin(args0)
            })
        })

    /**
     * A human-readable name for the layer.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * ID of the stack the layer will belong to.
     */
    public val stackId: Output<String>
        get() = javaResource.stackId().applyValue({ args0 -> args0 })

    /**
     * Names of a set of system packages to install on the layer's instances.
     */
    public val systemPackages: Output<List<String>>?
        get() = javaResource.systemPackages().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * The following extra optional arguments, all lists of Chef recipe names, allow
     * custom Chef recipes to be applied to layer instances at the five different
     * lifecycle events, if custom cookbooks are enabled on the layer's stack:
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Whether to use EBS-optimized instances.
     */
    public val useEbsOptimizedInstances: Output<Boolean>?
        get() = javaResource.useEbsOptimizedInstances().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object MemcachedLayerMapper : ResourceMapper<MemcachedLayer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.opsworks.MemcachedLayer::class == javaResource::class

    override fun map(javaResource: Resource): MemcachedLayer = MemcachedLayer(
        javaResource as
            com.pulumi.aws.opsworks.MemcachedLayer,
    )
}

/**
 * @see [MemcachedLayer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MemcachedLayer].
 */
public suspend fun memcachedLayer(
    name: String,
    block: suspend MemcachedLayerResourceBuilder.() -> Unit,
): MemcachedLayer {
    val builder = MemcachedLayerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MemcachedLayer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun memcachedLayer(name: String): MemcachedLayer {
    val builder = MemcachedLayerResourceBuilder()
    builder.name(name)
    return builder.build()
}
