@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin

import com.pulumi.aws.opsworks.kotlin.outputs.MysqlLayerCloudwatchConfiguration
import com.pulumi.aws.opsworks.kotlin.outputs.MysqlLayerEbsVolume
import com.pulumi.aws.opsworks.kotlin.outputs.MysqlLayerLoadBasedAutoScaling
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.opsworks.kotlin.outputs.MysqlLayerCloudwatchConfiguration.Companion.toKotlin as mysqlLayerCloudwatchConfigurationToKotlin
import com.pulumi.aws.opsworks.kotlin.outputs.MysqlLayerEbsVolume.Companion.toKotlin as mysqlLayerEbsVolumeToKotlin
import com.pulumi.aws.opsworks.kotlin.outputs.MysqlLayerLoadBasedAutoScaling.Companion.toKotlin as mysqlLayerLoadBasedAutoScalingToKotlin

/**
 * Builder for [MysqlLayer].
 */
@PulumiTagMarker
public class MysqlLayerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MysqlLayerArgs = MysqlLayerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MysqlLayerArgsBuilder.() -> Unit) {
        val builder = MysqlLayerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MysqlLayer {
        val builtJavaResource = com.pulumi.aws.opsworks.MysqlLayer(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MysqlLayer(builtJavaResource)
    }
}

/**
 * Provides an OpsWorks MySQL layer resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const db = new aws.opsworks.MysqlLayer("db", {stackId: main.id});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * db = aws.opsworks.MysqlLayer("db", stack_id=main["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var db = new Aws.OpsWorks.MysqlLayer("db", new()
 *     {
 *         StackId = main.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/opsworks"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := opsworks.NewMysqlLayer(ctx, "db", &opsworks.MysqlLayerArgs{
 * 			StackId: pulumi.Any(main.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opsworks.MysqlLayer;
 * import com.pulumi.aws.opsworks.MysqlLayerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var db = new MysqlLayer("db", MysqlLayerArgs.builder()
 *             .stackId(main.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   db:
 *     type: aws:opsworks:MysqlLayer
 *     properties:
 *       stackId: ${main.id}
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class MysqlLayer internal constructor(
    override val javaResource: com.pulumi.aws.opsworks.MysqlLayer,
) : KotlinCustomResource(javaResource, MysqlLayerMapper) {
    /**
     * The Amazon Resource Name(ARN) of the layer.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Whether to automatically assign an elastic IP address to the layer's instances.
     */
    public val autoAssignElasticIps: Output<Boolean>?
        get() = javaResource.autoAssignElasticIps().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * For stacks belonging to a VPC, whether to automatically assign a public IP address to each of the layer's instances.
     */
    public val autoAssignPublicIps: Output<Boolean>?
        get() = javaResource.autoAssignPublicIps().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to enable auto-healing for the layer.
     */
    public val autoHealing: Output<Boolean>?
        get() = javaResource.autoHealing().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val cloudwatchConfiguration: Output<MysqlLayerCloudwatchConfiguration>?
        get() = javaResource.cloudwatchConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> mysqlLayerCloudwatchConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    public val customConfigureRecipes: Output<List<String>>?
        get() = javaResource.customConfigureRecipes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    public val customDeployRecipes: Output<List<String>>?
        get() = javaResource.customDeployRecipes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The ARN of an IAM profile that will be used for the layer's instances.
     */
    public val customInstanceProfileArn: Output<String>?
        get() = javaResource.customInstanceProfileArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Custom JSON attributes to apply to the layer.
     */
    public val customJson: Output<String>?
        get() = javaResource.customJson().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Ids for a set of security groups to apply to the layer's instances.
     */
    public val customSecurityGroupIds: Output<List<String>>?
        get() = javaResource.customSecurityGroupIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    public val customSetupRecipes: Output<List<String>>?
        get() = javaResource.customSetupRecipes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    public val customShutdownRecipes: Output<List<String>>?
        get() = javaResource.customShutdownRecipes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    public val customUndeployRecipes: Output<List<String>>?
        get() = javaResource.customUndeployRecipes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Whether to enable Elastic Load Balancing connection draining.
     */
    public val drainElbOnShutdown: Output<Boolean>?
        get() = javaResource.drainElbOnShutdown().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
     */
    public val ebsVolumes: Output<List<MysqlLayerEbsVolume>>
        get() = javaResource.ebsVolumes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    mysqlLayerEbsVolumeToKotlin(args0)
                })
            })
        })

    /**
     * Name of an Elastic Load Balancer to attach to this layer
     */
    public val elasticLoadBalancer: Output<String>?
        get() = javaResource.elasticLoadBalancer().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to install OS and package updates on each instance when it boots.
     */
    public val installUpdatesOnBoot: Output<Boolean>?
        get() = javaResource.installUpdatesOnBoot().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The time, in seconds, that OpsWorks will wait for Chef to complete after triggering the Shutdown event.
     */
    public val instanceShutdownTimeout: Output<Int>?
        get() = javaResource.instanceShutdownTimeout().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val loadBasedAutoScaling: Output<MysqlLayerLoadBasedAutoScaling>
        get() = javaResource.loadBasedAutoScaling().applyValue({ args0 ->
            args0.let({ args0 ->
                mysqlLayerLoadBasedAutoScalingToKotlin(args0)
            })
        })

    /**
     * A human-readable name for the layer.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Root password to use for MySQL.
     */
    public val rootPassword: Output<String>?
        get() = javaResource.rootPassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to set the root user password to all instances in the stack so they can access the instances in this layer.
     */
    public val rootPasswordOnAllInstances: Output<Boolean>?
        get() = javaResource.rootPasswordOnAllInstances().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ID of the stack the layer will belong to.
     */
    public val stackId: Output<String>
        get() = javaResource.stackId().applyValue({ args0 -> args0 })

    /**
     * Names of a set of system packages to install on the layer's instances.
     */
    public val systemPackages: Output<List<String>>?
        get() = javaResource.systemPackages().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * The following extra optional arguments, all lists of Chef recipe names, allow
     * custom Chef recipes to be applied to layer instances at the five different
     * lifecycle events, if custom cookbooks are enabled on the layer's stack:
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Whether to use EBS-optimized instances.
     */
    public val useEbsOptimizedInstances: Output<Boolean>?
        get() = javaResource.useEbsOptimizedInstances().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object MysqlLayerMapper : ResourceMapper<MysqlLayer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.opsworks.MysqlLayer::class == javaResource::class

    override fun map(javaResource: Resource): MysqlLayer = MysqlLayer(
        javaResource as
            com.pulumi.aws.opsworks.MysqlLayer,
    )
}

/**
 * @see [MysqlLayer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MysqlLayer].
 */
public suspend fun mysqlLayer(name: String, block: suspend MysqlLayerResourceBuilder.() -> Unit): MysqlLayer {
    val builder = MysqlLayerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MysqlLayer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun mysqlLayer(name: String): MysqlLayer {
    val builder = MysqlLayerResourceBuilder()
    builder.name(name)
    return builder.build()
}
