@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Permission].
 */
@PulumiTagMarker
public class PermissionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PermissionArgs = PermissionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PermissionArgsBuilder.() -> Unit) {
        val builder = PermissionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Permission {
        val builtJavaResource = com.pulumi.aws.opsworks.Permission(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Permission(builtJavaResource)
    }
}

/**
 * Provides an OpsWorks permission resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const myStackPermission = new aws.opsworks.Permission("my_stack_permission", {
 *     allowSsh: true,
 *     allowSudo: true,
 *     level: "iam_only",
 *     userArn: user.arn,
 *     stackId: stack.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * my_stack_permission = aws.opsworks.Permission("my_stack_permission",
 *     allow_ssh=True,
 *     allow_sudo=True,
 *     level="iam_only",
 *     user_arn=user["arn"],
 *     stack_id=stack["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var myStackPermission = new Aws.OpsWorks.Permission("my_stack_permission", new()
 *     {
 *         AllowSsh = true,
 *         AllowSudo = true,
 *         Level = "iam_only",
 *         UserArn = user.Arn,
 *         StackId = stack.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/opsworks"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := opsworks.NewPermission(ctx, "my_stack_permission", &opsworks.PermissionArgs{
 * 			AllowSsh:  pulumi.Bool(true),
 * 			AllowSudo: pulumi.Bool(true),
 * 			Level:     pulumi.String("iam_only"),
 * 			UserArn:   pulumi.Any(user.Arn),
 * 			StackId:   pulumi.Any(stack.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opsworks.Permission;
 * import com.pulumi.aws.opsworks.PermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myStackPermission = new Permission("myStackPermission", PermissionArgs.builder()
 *             .allowSsh(true)
 *             .allowSudo(true)
 *             .level("iam_only")
 *             .userArn(user.arn())
 *             .stackId(stack.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   myStackPermission:
 *     type: aws:opsworks:Permission
 *     name: my_stack_permission
 *     properties:
 *       allowSsh: true
 *       allowSudo: true
 *       level: iam_only
 *       userArn: ${user.arn}
 *       stackId: ${stack.id}
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class Permission internal constructor(
    override val javaResource: com.pulumi.aws.opsworks.Permission,
) : KotlinCustomResource(javaResource, PermissionMapper) {
    /**
     * Whether the user is allowed to use SSH to communicate with the instance
     */
    public val allowSsh: Output<Boolean>
        get() = javaResource.allowSsh().applyValue({ args0 -> args0 })

    /**
     * Whether the user is allowed to use sudo to elevate privileges
     */
    public val allowSudo: Output<Boolean>
        get() = javaResource.allowSudo().applyValue({ args0 -> args0 })

    /**
     * The users permission level. Mus be one of `deny`, `show`, `deploy`, `manage`, `iam_only`
     */
    public val level: Output<String>
        get() = javaResource.level().applyValue({ args0 -> args0 })

    /**
     * The stack to set the permissions for
     */
    public val stackId: Output<String>
        get() = javaResource.stackId().applyValue({ args0 -> args0 })

    /**
     * The user's IAM ARN to set permissions for
     */
    public val userArn: Output<String>
        get() = javaResource.userArn().applyValue({ args0 -> args0 })
}

public object PermissionMapper : ResourceMapper<Permission> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.opsworks.Permission::class == javaResource::class

    override fun map(javaResource: Resource): Permission = Permission(
        javaResource as
            com.pulumi.aws.opsworks.Permission,
    )
}

/**
 * @see [Permission].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Permission].
 */
public suspend fun permission(name: String, block: suspend PermissionResourceBuilder.() -> Unit): Permission {
    val builder = PermissionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Permission].
 * @param name The _unique_ name of the resulting resource.
 */
public fun permission(name: String): Permission {
    val builder = PermissionResourceBuilder()
    builder.name(name)
    return builder.build()
}
