@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin

import com.pulumi.aws.opsworks.PhpAppLayerArgs.builder
import com.pulumi.aws.opsworks.kotlin.inputs.PhpAppLayerCloudwatchConfigurationArgs
import com.pulumi.aws.opsworks.kotlin.inputs.PhpAppLayerCloudwatchConfigurationArgsBuilder
import com.pulumi.aws.opsworks.kotlin.inputs.PhpAppLayerEbsVolumeArgs
import com.pulumi.aws.opsworks.kotlin.inputs.PhpAppLayerEbsVolumeArgsBuilder
import com.pulumi.aws.opsworks.kotlin.inputs.PhpAppLayerLoadBasedAutoScalingArgs
import com.pulumi.aws.opsworks.kotlin.inputs.PhpAppLayerLoadBasedAutoScalingArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an OpsWorks PHP application layer resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const app = new aws.opsworks.PhpAppLayer("app", {stackId: main.id});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * app = aws.opsworks.PhpAppLayer("app", stack_id=main["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var app = new Aws.OpsWorks.PhpAppLayer("app", new()
 *     {
 *         StackId = main.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/opsworks"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := opsworks.NewPhpAppLayer(ctx, "app", &opsworks.PhpAppLayerArgs{
 * 			StackId: pulumi.Any(main.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opsworks.PhpAppLayer;
 * import com.pulumi.aws.opsworks.PhpAppLayerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var app = new PhpAppLayer("app", PhpAppLayerArgs.builder()
 *             .stackId(main.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   app:
 *     type: aws:opsworks:PhpAppLayer
 *     properties:
 *       stackId: ${main.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import OpsWorks PHP Application Layers using the `id`. For example:
 * ```sh
 * $ pulumi import aws:opsworks/phpAppLayer:PhpAppLayer bar 00000000-0000-0000-0000-000000000000
 * ```
 * @property autoAssignElasticIps Whether to automatically assign an elastic IP address to the layer's instances.
 * @property autoAssignPublicIps For stacks belonging to a VPC, whether to automatically assign a public IP address to each of the layer's instances.
 * @property autoHealing Whether to enable auto-healing for the layer.
 * @property cloudwatchConfiguration
 * @property customConfigureRecipes
 * @property customDeployRecipes
 * @property customInstanceProfileArn The ARN of an IAM profile that will be used for the layer's instances.
 * @property customJson Custom JSON attributes to apply to the layer.
 * @property customSecurityGroupIds Ids for a set of security groups to apply to the layer's instances.
 * @property customSetupRecipes
 * @property customShutdownRecipes
 * @property customUndeployRecipes
 * @property drainElbOnShutdown Whether to enable Elastic Load Balancing connection draining.
 * @property ebsVolumes `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
 * @property elasticLoadBalancer Name of an Elastic Load Balancer to attach to this layer
 * @property installUpdatesOnBoot Whether to install OS and package updates on each instance when it boots.
 * @property instanceShutdownTimeout The time, in seconds, that OpsWorks will wait for Chef to complete after triggering the Shutdown event.
 * @property loadBasedAutoScaling
 * @property name A human-readable name for the layer.
 * @property stackId ID of the stack the layer will belong to.
 * @property systemPackages Names of a set of system packages to install on the layer's instances.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * The following extra optional arguments, all lists of Chef recipe names, allow
 * custom Chef recipes to be applied to layer instances at the five different
 * lifecycle events, if custom cookbooks are enabled on the layer's stack:
 * @property useEbsOptimizedInstances Whether to use EBS-optimized instances.
 */
public data class PhpAppLayerArgs(
    public val autoAssignElasticIps: Output<Boolean>? = null,
    public val autoAssignPublicIps: Output<Boolean>? = null,
    public val autoHealing: Output<Boolean>? = null,
    public val cloudwatchConfiguration: Output<PhpAppLayerCloudwatchConfigurationArgs>? = null,
    public val customConfigureRecipes: Output<List<String>>? = null,
    public val customDeployRecipes: Output<List<String>>? = null,
    public val customInstanceProfileArn: Output<String>? = null,
    public val customJson: Output<String>? = null,
    public val customSecurityGroupIds: Output<List<String>>? = null,
    public val customSetupRecipes: Output<List<String>>? = null,
    public val customShutdownRecipes: Output<List<String>>? = null,
    public val customUndeployRecipes: Output<List<String>>? = null,
    public val drainElbOnShutdown: Output<Boolean>? = null,
    public val ebsVolumes: Output<List<PhpAppLayerEbsVolumeArgs>>? = null,
    public val elasticLoadBalancer: Output<String>? = null,
    public val installUpdatesOnBoot: Output<Boolean>? = null,
    public val instanceShutdownTimeout: Output<Int>? = null,
    public val loadBasedAutoScaling: Output<PhpAppLayerLoadBasedAutoScalingArgs>? = null,
    public val name: Output<String>? = null,
    public val stackId: Output<String>? = null,
    public val systemPackages: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val useEbsOptimizedInstances: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.opsworks.PhpAppLayerArgs> {
    override fun toJava(): com.pulumi.aws.opsworks.PhpAppLayerArgs =
        com.pulumi.aws.opsworks.PhpAppLayerArgs.builder()
            .autoAssignElasticIps(autoAssignElasticIps?.applyValue({ args0 -> args0 }))
            .autoAssignPublicIps(autoAssignPublicIps?.applyValue({ args0 -> args0 }))
            .autoHealing(autoHealing?.applyValue({ args0 -> args0 }))
            .cloudwatchConfiguration(
                cloudwatchConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .customConfigureRecipes(
                customConfigureRecipes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .customDeployRecipes(customDeployRecipes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .customInstanceProfileArn(customInstanceProfileArn?.applyValue({ args0 -> args0 }))
            .customJson(customJson?.applyValue({ args0 -> args0 }))
            .customSecurityGroupIds(
                customSecurityGroupIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .customSetupRecipes(customSetupRecipes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .customShutdownRecipes(customShutdownRecipes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .customUndeployRecipes(customUndeployRecipes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .drainElbOnShutdown(drainElbOnShutdown?.applyValue({ args0 -> args0 }))
            .ebsVolumes(
                ebsVolumes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .elasticLoadBalancer(elasticLoadBalancer?.applyValue({ args0 -> args0 }))
            .installUpdatesOnBoot(installUpdatesOnBoot?.applyValue({ args0 -> args0 }))
            .instanceShutdownTimeout(instanceShutdownTimeout?.applyValue({ args0 -> args0 }))
            .loadBasedAutoScaling(
                loadBasedAutoScaling?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .stackId(stackId?.applyValue({ args0 -> args0 }))
            .systemPackages(systemPackages?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .useEbsOptimizedInstances(useEbsOptimizedInstances?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PhpAppLayerArgs].
 */
@PulumiTagMarker
public class PhpAppLayerArgsBuilder internal constructor() {
    private var autoAssignElasticIps: Output<Boolean>? = null

    private var autoAssignPublicIps: Output<Boolean>? = null

    private var autoHealing: Output<Boolean>? = null

    private var cloudwatchConfiguration: Output<PhpAppLayerCloudwatchConfigurationArgs>? = null

    private var customConfigureRecipes: Output<List<String>>? = null

    private var customDeployRecipes: Output<List<String>>? = null

    private var customInstanceProfileArn: Output<String>? = null

    private var customJson: Output<String>? = null

    private var customSecurityGroupIds: Output<List<String>>? = null

    private var customSetupRecipes: Output<List<String>>? = null

    private var customShutdownRecipes: Output<List<String>>? = null

    private var customUndeployRecipes: Output<List<String>>? = null

    private var drainElbOnShutdown: Output<Boolean>? = null

    private var ebsVolumes: Output<List<PhpAppLayerEbsVolumeArgs>>? = null

    private var elasticLoadBalancer: Output<String>? = null

    private var installUpdatesOnBoot: Output<Boolean>? = null

    private var instanceShutdownTimeout: Output<Int>? = null

    private var loadBasedAutoScaling: Output<PhpAppLayerLoadBasedAutoScalingArgs>? = null

    private var name: Output<String>? = null

    private var stackId: Output<String>? = null

    private var systemPackages: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var useEbsOptimizedInstances: Output<Boolean>? = null

    /**
     * @param value Whether to automatically assign an elastic IP address to the layer's instances.
     */
    @JvmName("xgxmjocmlxejqlsv")
    public suspend fun autoAssignElasticIps(`value`: Output<Boolean>) {
        this.autoAssignElasticIps = value
    }

    /**
     * @param value For stacks belonging to a VPC, whether to automatically assign a public IP address to each of the layer's instances.
     */
    @JvmName("kkfobuxmcycvpche")
    public suspend fun autoAssignPublicIps(`value`: Output<Boolean>) {
        this.autoAssignPublicIps = value
    }

    /**
     * @param value Whether to enable auto-healing for the layer.
     */
    @JvmName("rohxuolnvbyvlojt")
    public suspend fun autoHealing(`value`: Output<Boolean>) {
        this.autoHealing = value
    }

    /**
     * @param value
     */
    @JvmName("guomdggobotdqwav")
    public suspend fun cloudwatchConfiguration(`value`: Output<PhpAppLayerCloudwatchConfigurationArgs>) {
        this.cloudwatchConfiguration = value
    }

    /**
     * @param value
     */
    @JvmName("qjnpitaopcdqejxs")
    public suspend fun customConfigureRecipes(`value`: Output<List<String>>) {
        this.customConfigureRecipes = value
    }

    @JvmName("moiiypfmllkrurqd")
    public suspend fun customConfigureRecipes(vararg values: Output<String>) {
        this.customConfigureRecipes = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("nanubymqvfxxnysp")
    public suspend fun customConfigureRecipes(values: List<Output<String>>) {
        this.customConfigureRecipes = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("hypyhrtvvckwkscp")
    public suspend fun customDeployRecipes(`value`: Output<List<String>>) {
        this.customDeployRecipes = value
    }

    @JvmName("khdjhhtyxjnxvmvc")
    public suspend fun customDeployRecipes(vararg values: Output<String>) {
        this.customDeployRecipes = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("njpdnvnrkybnhmca")
    public suspend fun customDeployRecipes(values: List<Output<String>>) {
        this.customDeployRecipes = Output.all(values)
    }

    /**
     * @param value The ARN of an IAM profile that will be used for the layer's instances.
     */
    @JvmName("boctxavvxkvoicgm")
    public suspend fun customInstanceProfileArn(`value`: Output<String>) {
        this.customInstanceProfileArn = value
    }

    /**
     * @param value Custom JSON attributes to apply to the layer.
     */
    @JvmName("jlixlpwvdwcxnxfp")
    public suspend fun customJson(`value`: Output<String>) {
        this.customJson = value
    }

    /**
     * @param value Ids for a set of security groups to apply to the layer's instances.
     */
    @JvmName("vrdecnlmgukagkqp")
    public suspend fun customSecurityGroupIds(`value`: Output<List<String>>) {
        this.customSecurityGroupIds = value
    }

    @JvmName("aenksljfgkabbjnd")
    public suspend fun customSecurityGroupIds(vararg values: Output<String>) {
        this.customSecurityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values Ids for a set of security groups to apply to the layer's instances.
     */
    @JvmName("leteuetrbmfjvwwp")
    public suspend fun customSecurityGroupIds(values: List<Output<String>>) {
        this.customSecurityGroupIds = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("aiqpyoyuvqsmcgas")
    public suspend fun customSetupRecipes(`value`: Output<List<String>>) {
        this.customSetupRecipes = value
    }

    @JvmName("vsouryxjhxevpwoi")
    public suspend fun customSetupRecipes(vararg values: Output<String>) {
        this.customSetupRecipes = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("owmopgwofsefxhkd")
    public suspend fun customSetupRecipes(values: List<Output<String>>) {
        this.customSetupRecipes = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("uxysnoerieyylgbs")
    public suspend fun customShutdownRecipes(`value`: Output<List<String>>) {
        this.customShutdownRecipes = value
    }

    @JvmName("dfjqwgtghdlijabk")
    public suspend fun customShutdownRecipes(vararg values: Output<String>) {
        this.customShutdownRecipes = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("gyrgfjtporkjefrd")
    public suspend fun customShutdownRecipes(values: List<Output<String>>) {
        this.customShutdownRecipes = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("ougbtpodqrpnsmmw")
    public suspend fun customUndeployRecipes(`value`: Output<List<String>>) {
        this.customUndeployRecipes = value
    }

    @JvmName("tngefqhbeaeyhuev")
    public suspend fun customUndeployRecipes(vararg values: Output<String>) {
        this.customUndeployRecipes = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("rcylnaxpppiojtri")
    public suspend fun customUndeployRecipes(values: List<Output<String>>) {
        this.customUndeployRecipes = Output.all(values)
    }

    /**
     * @param value Whether to enable Elastic Load Balancing connection draining.
     */
    @JvmName("tfapmbuqgyoaywcr")
    public suspend fun drainElbOnShutdown(`value`: Output<Boolean>) {
        this.drainElbOnShutdown = value
    }

    /**
     * @param value `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
     */
    @JvmName("yjtxkblvffrunuwn")
    public suspend fun ebsVolumes(`value`: Output<List<PhpAppLayerEbsVolumeArgs>>) {
        this.ebsVolumes = value
    }

    @JvmName("sourmriucetkksxj")
    public suspend fun ebsVolumes(vararg values: Output<PhpAppLayerEbsVolumeArgs>) {
        this.ebsVolumes = Output.all(values.asList())
    }

    /**
     * @param values `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
     */
    @JvmName("bysrrayllrpywyaw")
    public suspend fun ebsVolumes(values: List<Output<PhpAppLayerEbsVolumeArgs>>) {
        this.ebsVolumes = Output.all(values)
    }

    /**
     * @param value Name of an Elastic Load Balancer to attach to this layer
     */
    @JvmName("exkjuoxveafbldwh")
    public suspend fun elasticLoadBalancer(`value`: Output<String>) {
        this.elasticLoadBalancer = value
    }

    /**
     * @param value Whether to install OS and package updates on each instance when it boots.
     */
    @JvmName("tqboytbkcwhgapip")
    public suspend fun installUpdatesOnBoot(`value`: Output<Boolean>) {
        this.installUpdatesOnBoot = value
    }

    /**
     * @param value The time, in seconds, that OpsWorks will wait for Chef to complete after triggering the Shutdown event.
     */
    @JvmName("hhenmosxibmfncrm")
    public suspend fun instanceShutdownTimeout(`value`: Output<Int>) {
        this.instanceShutdownTimeout = value
    }

    /**
     * @param value
     */
    @JvmName("lleljtgnqjfeagcv")
    public suspend fun loadBasedAutoScaling(`value`: Output<PhpAppLayerLoadBasedAutoScalingArgs>) {
        this.loadBasedAutoScaling = value
    }

    /**
     * @param value A human-readable name for the layer.
     */
    @JvmName("wjwntjhvfvxkxnlh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value ID of the stack the layer will belong to.
     */
    @JvmName("vpkbyhgwyvsxmffg")
    public suspend fun stackId(`value`: Output<String>) {
        this.stackId = value
    }

    /**
     * @param value Names of a set of system packages to install on the layer's instances.
     */
    @JvmName("vktviiymmukjwxtc")
    public suspend fun systemPackages(`value`: Output<List<String>>) {
        this.systemPackages = value
    }

    @JvmName("glrjnlujicstdgoa")
    public suspend fun systemPackages(vararg values: Output<String>) {
        this.systemPackages = Output.all(values.asList())
    }

    /**
     * @param values Names of a set of system packages to install on the layer's instances.
     */
    @JvmName("hyasskppokwhctdu")
    public suspend fun systemPackages(values: List<Output<String>>) {
        this.systemPackages = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * The following extra optional arguments, all lists of Chef recipe names, allow
     * custom Chef recipes to be applied to layer instances at the five different
     * lifecycle events, if custom cookbooks are enabled on the layer's stack:
     */
    @JvmName("itsudddecqocglko")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Whether to use EBS-optimized instances.
     */
    @JvmName("aiisgssfidocpteq")
    public suspend fun useEbsOptimizedInstances(`value`: Output<Boolean>) {
        this.useEbsOptimizedInstances = value
    }

    /**
     * @param value Whether to automatically assign an elastic IP address to the layer's instances.
     */
    @JvmName("vdiuijjlmgamsmpd")
    public suspend fun autoAssignElasticIps(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoAssignElasticIps = mapped
    }

    /**
     * @param value For stacks belonging to a VPC, whether to automatically assign a public IP address to each of the layer's instances.
     */
    @JvmName("kjipbslfodgowtln")
    public suspend fun autoAssignPublicIps(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoAssignPublicIps = mapped
    }

    /**
     * @param value Whether to enable auto-healing for the layer.
     */
    @JvmName("ixbyujseoqedahah")
    public suspend fun autoHealing(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoHealing = mapped
    }

    /**
     * @param value
     */
    @JvmName("guttoiltjjepgnue")
    public suspend fun cloudwatchConfiguration(`value`: PhpAppLayerCloudwatchConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchConfiguration = mapped
    }

    /**
     * @param argument
     */
    @JvmName("clykwuldikhbbsek")
    public suspend fun cloudwatchConfiguration(argument: suspend PhpAppLayerCloudwatchConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = PhpAppLayerCloudwatchConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.cloudwatchConfiguration = mapped
    }

    /**
     * @param value
     */
    @JvmName("vtnoqeeuvjpporua")
    public suspend fun customConfigureRecipes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customConfigureRecipes = mapped
    }

    /**
     * @param values
     */
    @JvmName("lfkusyikdqkmowii")
    public suspend fun customConfigureRecipes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customConfigureRecipes = mapped
    }

    /**
     * @param value
     */
    @JvmName("drmnlkdrvovsgldr")
    public suspend fun customDeployRecipes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customDeployRecipes = mapped
    }

    /**
     * @param values
     */
    @JvmName("wgvvhtrdjloshoov")
    public suspend fun customDeployRecipes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customDeployRecipes = mapped
    }

    /**
     * @param value The ARN of an IAM profile that will be used for the layer's instances.
     */
    @JvmName("lpubndlyhhhqhgep")
    public suspend fun customInstanceProfileArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customInstanceProfileArn = mapped
    }

    /**
     * @param value Custom JSON attributes to apply to the layer.
     */
    @JvmName("dkivgpgrfbfcpstv")
    public suspend fun customJson(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customJson = mapped
    }

    /**
     * @param value Ids for a set of security groups to apply to the layer's instances.
     */
    @JvmName("gjetdyqykbsbbuxs")
    public suspend fun customSecurityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customSecurityGroupIds = mapped
    }

    /**
     * @param values Ids for a set of security groups to apply to the layer's instances.
     */
    @JvmName("xakjbmueoanjqlic")
    public suspend fun customSecurityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customSecurityGroupIds = mapped
    }

    /**
     * @param value
     */
    @JvmName("jxwbmcaaxcoagwse")
    public suspend fun customSetupRecipes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customSetupRecipes = mapped
    }

    /**
     * @param values
     */
    @JvmName("nehorvymifmsjmxc")
    public suspend fun customSetupRecipes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customSetupRecipes = mapped
    }

    /**
     * @param value
     */
    @JvmName("iipmvmsaophpljdj")
    public suspend fun customShutdownRecipes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customShutdownRecipes = mapped
    }

    /**
     * @param values
     */
    @JvmName("sehvfqxdeuxemjct")
    public suspend fun customShutdownRecipes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customShutdownRecipes = mapped
    }

    /**
     * @param value
     */
    @JvmName("ytruryyhyixxjxyj")
    public suspend fun customUndeployRecipes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customUndeployRecipes = mapped
    }

    /**
     * @param values
     */
    @JvmName("nuyhqjmawxjjmrjr")
    public suspend fun customUndeployRecipes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customUndeployRecipes = mapped
    }

    /**
     * @param value Whether to enable Elastic Load Balancing connection draining.
     */
    @JvmName("ocykycqkspofaesy")
    public suspend fun drainElbOnShutdown(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.drainElbOnShutdown = mapped
    }

    /**
     * @param value `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
     */
    @JvmName("qgbmhnupisnuxbtl")
    public suspend fun ebsVolumes(`value`: List<PhpAppLayerEbsVolumeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebsVolumes = mapped
    }

    /**
     * @param argument `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
     */
    @JvmName("ivfrsfivugwmvfky")
    public suspend fun ebsVolumes(argument: List<suspend PhpAppLayerEbsVolumeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PhpAppLayerEbsVolumeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ebsVolumes = mapped
    }

    /**
     * @param argument `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
     */
    @JvmName("eucxuefuwddopfhd")
    public suspend fun ebsVolumes(vararg argument: suspend PhpAppLayerEbsVolumeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PhpAppLayerEbsVolumeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ebsVolumes = mapped
    }

    /**
     * @param argument `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
     */
    @JvmName("jtqgcnojgqmvectv")
    public suspend fun ebsVolumes(argument: suspend PhpAppLayerEbsVolumeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PhpAppLayerEbsVolumeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ebsVolumes = mapped
    }

    /**
     * @param values `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
     */
    @JvmName("ohqowmfcwxnkkaqi")
    public suspend fun ebsVolumes(vararg values: PhpAppLayerEbsVolumeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ebsVolumes = mapped
    }

    /**
     * @param value Name of an Elastic Load Balancer to attach to this layer
     */
    @JvmName("jsvlkkksoxaunmrr")
    public suspend fun elasticLoadBalancer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticLoadBalancer = mapped
    }

    /**
     * @param value Whether to install OS and package updates on each instance when it boots.
     */
    @JvmName("cfkjfxlckiouooub")
    public suspend fun installUpdatesOnBoot(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.installUpdatesOnBoot = mapped
    }

    /**
     * @param value The time, in seconds, that OpsWorks will wait for Chef to complete after triggering the Shutdown event.
     */
    @JvmName("wcbcjjlkqqprpygg")
    public suspend fun instanceShutdownTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceShutdownTimeout = mapped
    }

    /**
     * @param value
     */
    @JvmName("pfjxpyypcetyewql")
    public suspend fun loadBasedAutoScaling(`value`: PhpAppLayerLoadBasedAutoScalingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBasedAutoScaling = mapped
    }

    /**
     * @param argument
     */
    @JvmName("lonwgxhfjvtlqkdv")
    public suspend fun loadBasedAutoScaling(argument: suspend PhpAppLayerLoadBasedAutoScalingArgsBuilder.() -> Unit) {
        val toBeMapped = PhpAppLayerLoadBasedAutoScalingArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.loadBasedAutoScaling = mapped
    }

    /**
     * @param value A human-readable name for the layer.
     */
    @JvmName("manknectavobndmw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value ID of the stack the layer will belong to.
     */
    @JvmName("jdxkogfcjxkdumpd")
    public suspend fun stackId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stackId = mapped
    }

    /**
     * @param value Names of a set of system packages to install on the layer's instances.
     */
    @JvmName("ddewfabgjlmjcuvl")
    public suspend fun systemPackages(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemPackages = mapped
    }

    /**
     * @param values Names of a set of system packages to install on the layer's instances.
     */
    @JvmName("gckepcaexbqkoeim")
    public suspend fun systemPackages(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.systemPackages = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * The following extra optional arguments, all lists of Chef recipe names, allow
     * custom Chef recipes to be applied to layer instances at the five different
     * lifecycle events, if custom cookbooks are enabled on the layer's stack:
     */
    @JvmName("wrkbowpfgpejwets")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * The following extra optional arguments, all lists of Chef recipe names, allow
     * custom Chef recipes to be applied to layer instances at the five different
     * lifecycle events, if custom cookbooks are enabled on the layer's stack:
     */
    @JvmName("ghggwnoxdwjrjksp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Whether to use EBS-optimized instances.
     */
    @JvmName("qfndnuhrhjahdxhs")
    public suspend fun useEbsOptimizedInstances(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useEbsOptimizedInstances = mapped
    }

    internal fun build(): PhpAppLayerArgs = PhpAppLayerArgs(
        autoAssignElasticIps = autoAssignElasticIps,
        autoAssignPublicIps = autoAssignPublicIps,
        autoHealing = autoHealing,
        cloudwatchConfiguration = cloudwatchConfiguration,
        customConfigureRecipes = customConfigureRecipes,
        customDeployRecipes = customDeployRecipes,
        customInstanceProfileArn = customInstanceProfileArn,
        customJson = customJson,
        customSecurityGroupIds = customSecurityGroupIds,
        customSetupRecipes = customSetupRecipes,
        customShutdownRecipes = customShutdownRecipes,
        customUndeployRecipes = customUndeployRecipes,
        drainElbOnShutdown = drainElbOnShutdown,
        ebsVolumes = ebsVolumes,
        elasticLoadBalancer = elasticLoadBalancer,
        installUpdatesOnBoot = installUpdatesOnBoot,
        instanceShutdownTimeout = instanceShutdownTimeout,
        loadBasedAutoScaling = loadBasedAutoScaling,
        name = name,
        stackId = stackId,
        systemPackages = systemPackages,
        tags = tags,
        useEbsOptimizedInstances = useEbsOptimizedInstances,
    )
}
