@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [RdsDbInstance].
 */
@PulumiTagMarker
public class RdsDbInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RdsDbInstanceArgs = RdsDbInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RdsDbInstanceArgsBuilder.() -> Unit) {
        val builder = RdsDbInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RdsDbInstance {
        val builtJavaResource = com.pulumi.aws.opsworks.RdsDbInstance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RdsDbInstance(builtJavaResource)
    }
}

/**
 * Provides an OpsWorks RDS DB Instance resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const myInstance = new aws.opsworks.RdsDbInstance("my_instance", {
 *     stackId: myStack.id,
 *     rdsDbInstanceArn: myInstanceAwsDbInstance.arn,
 *     dbUser: "someUser",
 *     dbPassword: "somePass",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * my_instance = aws.opsworks.RdsDbInstance("my_instance",
 *     stack_id=my_stack["id"],
 *     rds_db_instance_arn=my_instance_aws_db_instance["arn"],
 *     db_user="someUser",
 *     db_password="somePass")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var myInstance = new Aws.OpsWorks.RdsDbInstance("my_instance", new()
 *     {
 *         StackId = myStack.Id,
 *         RdsDbInstanceArn = myInstanceAwsDbInstance.Arn,
 *         DbUser = "someUser",
 *         DbPassword = "somePass",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/opsworks"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := opsworks.NewRdsDbInstance(ctx, "my_instance", &opsworks.RdsDbInstanceArgs{
 * 			StackId:          pulumi.Any(myStack.Id),
 * 			RdsDbInstanceArn: pulumi.Any(myInstanceAwsDbInstance.Arn),
 * 			DbUser:           pulumi.String("someUser"),
 * 			DbPassword:       pulumi.String("somePass"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opsworks.RdsDbInstance;
 * import com.pulumi.aws.opsworks.RdsDbInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myInstance = new RdsDbInstance("myInstance", RdsDbInstanceArgs.builder()
 *             .stackId(myStack.id())
 *             .rdsDbInstanceArn(myInstanceAwsDbInstance.arn())
 *             .dbUser("someUser")
 *             .dbPassword("somePass")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   myInstance:
 *     type: aws:opsworks:RdsDbInstance
 *     name: my_instance
 *     properties:
 *       stackId: ${myStack.id}
 *       rdsDbInstanceArn: ${myInstanceAwsDbInstance.arn}
 *       dbUser: someUser
 *       dbPassword: somePass
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class RdsDbInstance internal constructor(
    override val javaResource: com.pulumi.aws.opsworks.RdsDbInstance,
) : KotlinCustomResource(javaResource, RdsDbInstanceMapper) {
    /**
     * A db password
     */
    public val dbPassword: Output<String>
        get() = javaResource.dbPassword().applyValue({ args0 -> args0 })

    /**
     * A db username
     */
    public val dbUser: Output<String>
        get() = javaResource.dbUser().applyValue({ args0 -> args0 })

    /**
     * The db instance to register for this stack. Changing this will force a new resource.
     */
    public val rdsDbInstanceArn: Output<String>
        get() = javaResource.rdsDbInstanceArn().applyValue({ args0 -> args0 })

    /**
     * The stack to register a db instance for. Changing this will force a new resource.
     */
    public val stackId: Output<String>
        get() = javaResource.stackId().applyValue({ args0 -> args0 })
}

public object RdsDbInstanceMapper : ResourceMapper<RdsDbInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.opsworks.RdsDbInstance::class == javaResource::class

    override fun map(javaResource: Resource): RdsDbInstance = RdsDbInstance(
        javaResource as
            com.pulumi.aws.opsworks.RdsDbInstance,
    )
}

/**
 * @see [RdsDbInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RdsDbInstance].
 */
public suspend fun rdsDbInstance(
    name: String,
    block: suspend RdsDbInstanceResourceBuilder.() -> Unit,
): RdsDbInstance {
    val builder = RdsDbInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RdsDbInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun rdsDbInstance(name: String): RdsDbInstance {
    val builder = RdsDbInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
