@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin

import com.pulumi.aws.opsworks.RdsDbInstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an OpsWorks RDS DB Instance resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const myInstance = new aws.opsworks.RdsDbInstance("my_instance", {
 *     stackId: myStack.id,
 *     rdsDbInstanceArn: myInstanceAwsDbInstance.arn,
 *     dbUser: "someUser",
 *     dbPassword: "somePass",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * my_instance = aws.opsworks.RdsDbInstance("my_instance",
 *     stack_id=my_stack["id"],
 *     rds_db_instance_arn=my_instance_aws_db_instance["arn"],
 *     db_user="someUser",
 *     db_password="somePass")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var myInstance = new Aws.OpsWorks.RdsDbInstance("my_instance", new()
 *     {
 *         StackId = myStack.Id,
 *         RdsDbInstanceArn = myInstanceAwsDbInstance.Arn,
 *         DbUser = "someUser",
 *         DbPassword = "somePass",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/opsworks"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := opsworks.NewRdsDbInstance(ctx, "my_instance", &opsworks.RdsDbInstanceArgs{
 * 			StackId:          pulumi.Any(myStack.Id),
 * 			RdsDbInstanceArn: pulumi.Any(myInstanceAwsDbInstance.Arn),
 * 			DbUser:           pulumi.String("someUser"),
 * 			DbPassword:       pulumi.String("somePass"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opsworks.RdsDbInstance;
 * import com.pulumi.aws.opsworks.RdsDbInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myInstance = new RdsDbInstance("myInstance", RdsDbInstanceArgs.builder()
 *             .stackId(myStack.id())
 *             .rdsDbInstanceArn(myInstanceAwsDbInstance.arn())
 *             .dbUser("someUser")
 *             .dbPassword("somePass")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   myInstance:
 *     type: aws:opsworks:RdsDbInstance
 *     name: my_instance
 *     properties:
 *       stackId: ${myStack.id}
 *       rdsDbInstanceArn: ${myInstanceAwsDbInstance.arn}
 *       dbUser: someUser
 *       dbPassword: somePass
 * ```
 * <!--End PulumiCodeChooser -->
 * @property dbPassword A db password
 * @property dbUser A db username
 * @property rdsDbInstanceArn The db instance to register for this stack. Changing this will force a new resource.
 * @property stackId The stack to register a db instance for. Changing this will force a new resource.
 */
public data class RdsDbInstanceArgs(
    public val dbPassword: Output<String>? = null,
    public val dbUser: Output<String>? = null,
    public val rdsDbInstanceArn: Output<String>? = null,
    public val stackId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.opsworks.RdsDbInstanceArgs> {
    override fun toJava(): com.pulumi.aws.opsworks.RdsDbInstanceArgs =
        com.pulumi.aws.opsworks.RdsDbInstanceArgs.builder()
            .dbPassword(dbPassword?.applyValue({ args0 -> args0 }))
            .dbUser(dbUser?.applyValue({ args0 -> args0 }))
            .rdsDbInstanceArn(rdsDbInstanceArn?.applyValue({ args0 -> args0 }))
            .stackId(stackId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RdsDbInstanceArgs].
 */
@PulumiTagMarker
public class RdsDbInstanceArgsBuilder internal constructor() {
    private var dbPassword: Output<String>? = null

    private var dbUser: Output<String>? = null

    private var rdsDbInstanceArn: Output<String>? = null

    private var stackId: Output<String>? = null

    /**
     * @param value A db password
     */
    @JvmName("rhvumrpgnugehixg")
    public suspend fun dbPassword(`value`: Output<String>) {
        this.dbPassword = value
    }

    /**
     * @param value A db username
     */
    @JvmName("opdcoqiedrhwshgl")
    public suspend fun dbUser(`value`: Output<String>) {
        this.dbUser = value
    }

    /**
     * @param value The db instance to register for this stack. Changing this will force a new resource.
     */
    @JvmName("saxopbpcioqfhnuh")
    public suspend fun rdsDbInstanceArn(`value`: Output<String>) {
        this.rdsDbInstanceArn = value
    }

    /**
     * @param value The stack to register a db instance for. Changing this will force a new resource.
     */
    @JvmName("duxnbbpuhgvtffwu")
    public suspend fun stackId(`value`: Output<String>) {
        this.stackId = value
    }

    /**
     * @param value A db password
     */
    @JvmName("aayupktgbjxstevb")
    public suspend fun dbPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbPassword = mapped
    }

    /**
     * @param value A db username
     */
    @JvmName("tkjqlttfxqysumwu")
    public suspend fun dbUser(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbUser = mapped
    }

    /**
     * @param value The db instance to register for this stack. Changing this will force a new resource.
     */
    @JvmName("ivvwpopjkbwthccj")
    public suspend fun rdsDbInstanceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rdsDbInstanceArn = mapped
    }

    /**
     * @param value The stack to register a db instance for. Changing this will force a new resource.
     */
    @JvmName("wocnvbtidfyixmum")
    public suspend fun stackId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stackId = mapped
    }

    internal fun build(): RdsDbInstanceArgs = RdsDbInstanceArgs(
        dbPassword = dbPassword,
        dbUser = dbUser,
        rdsDbInstanceArn = rdsDbInstanceArn,
        stackId = stackId,
    )
}
