@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin

import com.pulumi.aws.opsworks.kotlin.outputs.StackCustomCookbooksSource
import com.pulumi.aws.opsworks.kotlin.outputs.StackCustomCookbooksSource.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Stack].
 */
@PulumiTagMarker
public class StackResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StackArgs = StackArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StackArgsBuilder.() -> Unit) {
        val builder = StackArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Stack {
        val builtJavaResource = com.pulumi.aws.opsworks.Stack(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Stack(builtJavaResource)
    }
}

/**
 * Provides an OpsWorks stack resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const main = new aws.opsworks.Stack("main", {
 *     name: "awesome-stack",
 *     region: "us-west-1",
 *     serviceRoleArn: opsworksAwsIamRole.arn,
 *     defaultInstanceProfileArn: opsworks.arn,
 *     tags: {
 *         Name: "foobar-stack",
 *     },
 *     customJson: `{
 *  "foobar": {
 *     "version": "1.0.0"
 *   }
 * }
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * main = aws.opsworks.Stack("main",
 *     name="awesome-stack",
 *     region="us-west-1",
 *     service_role_arn=opsworks_aws_iam_role["arn"],
 *     default_instance_profile_arn=opsworks["arn"],
 *     tags={
 *         "Name": "foobar-stack",
 *     },
 *     custom_json="""{
 *  "foobar": {
 *     "version": "1.0.0"
 *   }
 * }
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var main = new Aws.OpsWorks.Stack("main", new()
 *     {
 *         Name = "awesome-stack",
 *         Region = "us-west-1",
 *         ServiceRoleArn = opsworksAwsIamRole.Arn,
 *         DefaultInstanceProfileArn = opsworks.Arn,
 *         Tags =
 *         {
 *             { "Name", "foobar-stack" },
 *         },
 *         CustomJson = @"{
 *  ""foobar"": {
 *     ""version"": ""1.0.0""
 *   }
 * }
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/opsworks"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := opsworks.NewStack(ctx, "main", &opsworks.StackArgs{
 * 			Name:                      pulumi.String("awesome-stack"),
 * 			Region:                    pulumi.String("us-west-1"),
 * 			ServiceRoleArn:            pulumi.Any(opsworksAwsIamRole.Arn),
 * 			DefaultInstanceProfileArn: pulumi.Any(opsworks.Arn),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("foobar-stack"),
 * 			},
 * 			CustomJson: pulumi.String("{\n \"foobar\": {\n    \"version\": \"1.0.0\"\n  }\n}\n"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opsworks.Stack;
 * import com.pulumi.aws.opsworks.StackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new Stack("main", StackArgs.builder()
 *             .name("awesome-stack")
 *             .region("us-west-1")
 *             .serviceRoleArn(opsworksAwsIamRole.arn())
 *             .defaultInstanceProfileArn(opsworks.arn())
 *             .tags(Map.of("Name", "foobar-stack"))
 *             .customJson("""
 * {
 *  "foobar": {
 *     "version": "1.0.0"
 *   }
 * }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   main:
 *     type: aws:opsworks:Stack
 *     properties:
 *       name: awesome-stack
 *       region: us-west-1
 *       serviceRoleArn: ${opsworksAwsIamRole.arn}
 *       defaultInstanceProfileArn: ${opsworks.arn}
 *       tags:
 *         Name: foobar-stack
 *       customJson: |
 *         {
 *          "foobar": {
 *             "version": "1.0.0"
 *           }
 *         }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import OpsWorks stacks using the `id`. For example:
 * ```sh
 * $ pulumi import aws:opsworks/stack:Stack bar 00000000-0000-0000-0000-000000000000
 * ```
 */
public class Stack internal constructor(
    override val javaResource: com.pulumi.aws.opsworks.Stack,
) : KotlinCustomResource(javaResource, StackMapper) {
    /**
     * If set to `"LATEST"`, OpsWorks will automatically install the latest version.
     */
    public val agentVersion: Output<String>
        get() = javaResource.agentVersion().applyValue({ args0 -> args0 })

    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * If `manage_berkshelf` is enabled, the version of Berkshelf to use.
     */
    public val berkshelfVersion: Output<String>?
        get() = javaResource.berkshelfVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Color to paint next to the stack's resources in the OpsWorks console.
     */
    public val color: Output<String>?
        get() = javaResource.color().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Name of the configuration manager to use. Defaults to "Chef".
     */
    public val configurationManagerName: Output<String>?
        get() = javaResource.configurationManagerName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Version of the configuration manager to use. Defaults to "11.4".
     */
    public val configurationManagerVersion: Output<String>?
        get() = javaResource.configurationManagerVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * When `use_custom_cookbooks` is set, provide this sub-object as described below.
     */
    public val customCookbooksSources: Output<List<StackCustomCookbooksSource>>
        get() = javaResource.customCookbooksSources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * Custom JSON attributes to apply to the entire stack.
     */
    public val customJson: Output<String>?
        get() = javaResource.customJson().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the availability zone where instances will be created by default.
     * Cannot be set when `vpc_id` is set.
     */
    public val defaultAvailabilityZone: Output<String>
        get() = javaResource.defaultAvailabilityZone().applyValue({ args0 -> args0 })

    /**
     * The ARN of an IAM Instance Profile that created instances will have by default.
     */
    public val defaultInstanceProfileArn: Output<String>
        get() = javaResource.defaultInstanceProfileArn().applyValue({ args0 -> args0 })

    /**
     * Name of OS that will be installed on instances by default.
     */
    public val defaultOs: Output<String>?
        get() = javaResource.defaultOs().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Name of the type of root device instances will have by default.
     */
    public val defaultRootDeviceType: Output<String>?
        get() = javaResource.defaultRootDeviceType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the SSH keypair that instances will have by default.
     */
    public val defaultSshKeyName: Output<String>?
        get() = javaResource.defaultSshKeyName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ID of the subnet in which instances will be created by default.
     * Required if `vpc_id` is set to a VPC other than the default VPC, and forbidden if it isn't.
     */
    public val defaultSubnetId: Output<String>
        get() = javaResource.defaultSubnetId().applyValue({ args0 -> args0 })

    /**
     * Keyword representing the naming scheme that will be used for instance hostnames within this stack.
     */
    public val hostnameTheme: Output<String>?
        get() = javaResource.hostnameTheme().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Boolean value controlling whether Opsworks will run Berkshelf for this stack.
     */
    public val manageBerkshelf: Output<Boolean>?
        get() = javaResource.manageBerkshelf().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the stack.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The name of the region where the stack will exist.
     */
    public val region: Output<String>
        get() = javaResource.region().applyValue({ args0 -> args0 })

    /**
     * The ARN of an IAM role that the OpsWorks service will act as.
     */
    public val serviceRoleArn: Output<String>
        get() = javaResource.serviceRoleArn().applyValue({ args0 -> args0 })

    public val stackEndpoint: Output<String>
        get() = javaResource.stackEndpoint().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource.
     * If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Boolean value controlling whether the custom cookbook settings are enabled.
     */
    public val useCustomCookbooks: Output<Boolean>?
        get() = javaResource.useCustomCookbooks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Boolean value controlling whether the standard OpsWorks security groups apply to created instances.
     */
    public val useOpsworksSecurityGroups: Output<Boolean>?
        get() = javaResource.useOpsworksSecurityGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ID of the VPC that this stack belongs to.
     * Defaults to the region's default VPC.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object StackMapper : ResourceMapper<Stack> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.opsworks.Stack::class == javaResource::class

    override fun map(javaResource: Resource): Stack = Stack(
        javaResource as
            com.pulumi.aws.opsworks.Stack,
    )
}

/**
 * @see [Stack].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Stack].
 */
public suspend fun stack(name: String, block: suspend StackResourceBuilder.() -> Unit): Stack {
    val builder = StackResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Stack].
 * @param name The _unique_ name of the resulting resource.
 */
public fun stack(name: String): Stack {
    val builder = StackResourceBuilder()
    builder.name(name)
    return builder.build()
}
