@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [UserProfile].
 */
@PulumiTagMarker
public class UserProfileResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UserProfileArgs = UserProfileArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UserProfileArgsBuilder.() -> Unit) {
        val builder = UserProfileArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): UserProfile {
        val builtJavaResource = com.pulumi.aws.opsworks.UserProfile(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return UserProfile(builtJavaResource)
    }
}

/**
 * Provides an OpsWorks User Profile resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const myProfile = new aws.opsworks.UserProfile("my_profile", {
 *     userArn: user.arn,
 *     sshUsername: "my_user",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * my_profile = aws.opsworks.UserProfile("my_profile",
 *     user_arn=user["arn"],
 *     ssh_username="my_user")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var myProfile = new Aws.OpsWorks.UserProfile("my_profile", new()
 *     {
 *         UserArn = user.Arn,
 *         SshUsername = "my_user",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/opsworks"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := opsworks.NewUserProfile(ctx, "my_profile", &opsworks.UserProfileArgs{
 * 			UserArn:     pulumi.Any(user.Arn),
 * 			SshUsername: pulumi.String("my_user"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opsworks.UserProfile;
 * import com.pulumi.aws.opsworks.UserProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myProfile = new UserProfile("myProfile", UserProfileArgs.builder()
 *             .userArn(user.arn())
 *             .sshUsername("my_user")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   myProfile:
 *     type: aws:opsworks:UserProfile
 *     name: my_profile
 *     properties:
 *       userArn: ${user.arn}
 *       sshUsername: my_user
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class UserProfile internal constructor(
    override val javaResource: com.pulumi.aws.opsworks.UserProfile,
) : KotlinCustomResource(javaResource, UserProfileMapper) {
    /**
     * Whether users can specify their own SSH public key through the My Settings page
     */
    public val allowSelfManagement: Output<Boolean>?
        get() = javaResource.allowSelfManagement().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The users public key
     */
    public val sshPublicKey: Output<String>?
        get() = javaResource.sshPublicKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ssh username, with witch this user wants to log in
     */
    public val sshUsername: Output<String>
        get() = javaResource.sshUsername().applyValue({ args0 -> args0 })

    /**
     * The user's IAM ARN
     */
    public val userArn: Output<String>
        get() = javaResource.userArn().applyValue({ args0 -> args0 })
}

public object UserProfileMapper : ResourceMapper<UserProfile> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.opsworks.UserProfile::class == javaResource::class

    override fun map(javaResource: Resource): UserProfile = UserProfile(
        javaResource as
            com.pulumi.aws.opsworks.UserProfile,
    )
}

/**
 * @see [UserProfile].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UserProfile].
 */
public suspend fun userProfile(name: String, block: suspend UserProfileResourceBuilder.() -> Unit): UserProfile {
    val builder = UserProfileResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UserProfile].
 * @param name The _unique_ name of the resulting resource.
 */
public fun userProfile(name: String): UserProfile {
    val builder = UserProfileResourceBuilder()
    builder.name(name)
    return builder.build()
}
