@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin

import com.pulumi.aws.opsworks.UserProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an OpsWorks User Profile resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const myProfile = new aws.opsworks.UserProfile("my_profile", {
 *     userArn: user.arn,
 *     sshUsername: "my_user",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * my_profile = aws.opsworks.UserProfile("my_profile",
 *     user_arn=user["arn"],
 *     ssh_username="my_user")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var myProfile = new Aws.OpsWorks.UserProfile("my_profile", new()
 *     {
 *         UserArn = user.Arn,
 *         SshUsername = "my_user",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/opsworks"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := opsworks.NewUserProfile(ctx, "my_profile", &opsworks.UserProfileArgs{
 * 			UserArn:     pulumi.Any(user.Arn),
 * 			SshUsername: pulumi.String("my_user"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opsworks.UserProfile;
 * import com.pulumi.aws.opsworks.UserProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myProfile = new UserProfile("myProfile", UserProfileArgs.builder()
 *             .userArn(user.arn())
 *             .sshUsername("my_user")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   myProfile:
 *     type: aws:opsworks:UserProfile
 *     name: my_profile
 *     properties:
 *       userArn: ${user.arn}
 *       sshUsername: my_user
 * ```
 * <!--End PulumiCodeChooser -->
 * @property allowSelfManagement Whether users can specify their own SSH public key through the My Settings page
 * @property sshPublicKey The users public key
 * @property sshUsername The ssh username, with witch this user wants to log in
 * @property userArn The user's IAM ARN
 */
public data class UserProfileArgs(
    public val allowSelfManagement: Output<Boolean>? = null,
    public val sshPublicKey: Output<String>? = null,
    public val sshUsername: Output<String>? = null,
    public val userArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.opsworks.UserProfileArgs> {
    override fun toJava(): com.pulumi.aws.opsworks.UserProfileArgs =
        com.pulumi.aws.opsworks.UserProfileArgs.builder()
            .allowSelfManagement(allowSelfManagement?.applyValue({ args0 -> args0 }))
            .sshPublicKey(sshPublicKey?.applyValue({ args0 -> args0 }))
            .sshUsername(sshUsername?.applyValue({ args0 -> args0 }))
            .userArn(userArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserProfileArgs].
 */
@PulumiTagMarker
public class UserProfileArgsBuilder internal constructor() {
    private var allowSelfManagement: Output<Boolean>? = null

    private var sshPublicKey: Output<String>? = null

    private var sshUsername: Output<String>? = null

    private var userArn: Output<String>? = null

    /**
     * @param value Whether users can specify their own SSH public key through the My Settings page
     */
    @JvmName("swrjorluqsejfrnb")
    public suspend fun allowSelfManagement(`value`: Output<Boolean>) {
        this.allowSelfManagement = value
    }

    /**
     * @param value The users public key
     */
    @JvmName("pprjjnuajeyiaidh")
    public suspend fun sshPublicKey(`value`: Output<String>) {
        this.sshPublicKey = value
    }

    /**
     * @param value The ssh username, with witch this user wants to log in
     */
    @JvmName("gnfwhxvdlmsmyucg")
    public suspend fun sshUsername(`value`: Output<String>) {
        this.sshUsername = value
    }

    /**
     * @param value The user's IAM ARN
     */
    @JvmName("uolvdfmtmfdtrkoq")
    public suspend fun userArn(`value`: Output<String>) {
        this.userArn = value
    }

    /**
     * @param value Whether users can specify their own SSH public key through the My Settings page
     */
    @JvmName("feuhqinvjngkodip")
    public suspend fun allowSelfManagement(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowSelfManagement = mapped
    }

    /**
     * @param value The users public key
     */
    @JvmName("tuxitbhjwadcjkvw")
    public suspend fun sshPublicKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sshPublicKey = mapped
    }

    /**
     * @param value The ssh username, with witch this user wants to log in
     */
    @JvmName("tpcpquyjepdvvqae")
    public suspend fun sshUsername(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sshUsername = mapped
    }

    /**
     * @param value The user's IAM ARN
     */
    @JvmName("ojcjstytklfflyrp")
    public suspend fun userArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userArn = mapped
    }

    internal fun build(): UserProfileArgs = UserProfileArgs(
        allowSelfManagement = allowSelfManagement,
        sshPublicKey = sshPublicKey,
        sshUsername = sshUsername,
        userArn = userArn,
    )
}
