@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin.inputs

import com.pulumi.aws.opsworks.inputs.CustomLayerCloudwatchConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property enabled
 * @property logStreams A block the specifies how an opsworks logs look like. See Log Streams.
 */
public data class CustomLayerCloudwatchConfigurationArgs(
    public val enabled: Output<Boolean>? = null,
    public val logStreams: Output<List<CustomLayerCloudwatchConfigurationLogStreamArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.opsworks.inputs.CustomLayerCloudwatchConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.opsworks.inputs.CustomLayerCloudwatchConfigurationArgs =
        com.pulumi.aws.opsworks.inputs.CustomLayerCloudwatchConfigurationArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .logStreams(
                logStreams?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [CustomLayerCloudwatchConfigurationArgs].
 */
@PulumiTagMarker
public class CustomLayerCloudwatchConfigurationArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var logStreams: Output<List<CustomLayerCloudwatchConfigurationLogStreamArgs>>? = null

    /**
     * @param value
     */
    @JvmName("ubomqbmevckcplja")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value A block the specifies how an opsworks logs look like. See Log Streams.
     */
    @JvmName("utrjdcienyjsfkin")
    public suspend fun logStreams(`value`: Output<List<CustomLayerCloudwatchConfigurationLogStreamArgs>>) {
        this.logStreams = value
    }

    @JvmName("olkrlnjfkdcqwcwo")
    public suspend fun logStreams(vararg values: Output<CustomLayerCloudwatchConfigurationLogStreamArgs>) {
        this.logStreams = Output.all(values.asList())
    }

    /**
     * @param values A block the specifies how an opsworks logs look like. See Log Streams.
     */
    @JvmName("hwewxgwclasowhkf")
    public suspend fun logStreams(values: List<Output<CustomLayerCloudwatchConfigurationLogStreamArgs>>) {
        this.logStreams = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("oykbqqjwshsiuxpx")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value A block the specifies how an opsworks logs look like. See Log Streams.
     */
    @JvmName("alodcvdslirnovgc")
    public suspend fun logStreams(`value`: List<CustomLayerCloudwatchConfigurationLogStreamArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logStreams = mapped
    }

    /**
     * @param argument A block the specifies how an opsworks logs look like. See Log Streams.
     */
    @JvmName("fokhsdlvtuvarfav")
    public suspend fun logStreams(argument: List<suspend CustomLayerCloudwatchConfigurationLogStreamArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CustomLayerCloudwatchConfigurationLogStreamArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.logStreams = mapped
    }

    /**
     * @param argument A block the specifies how an opsworks logs look like. See Log Streams.
     */
    @JvmName("pxlxusmnjxuiimxl")
    public suspend fun logStreams(vararg argument: suspend CustomLayerCloudwatchConfigurationLogStreamArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CustomLayerCloudwatchConfigurationLogStreamArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.logStreams = mapped
    }

    /**
     * @param argument A block the specifies how an opsworks logs look like. See Log Streams.
     */
    @JvmName("dbvidukpllhgymio")
    public suspend fun logStreams(argument: suspend CustomLayerCloudwatchConfigurationLogStreamArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CustomLayerCloudwatchConfigurationLogStreamArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.logStreams = mapped
    }

    /**
     * @param values A block the specifies how an opsworks logs look like. See Log Streams.
     */
    @JvmName("ussrgqgaooaslyvs")
    public suspend fun logStreams(vararg values: CustomLayerCloudwatchConfigurationLogStreamArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logStreams = mapped
    }

    internal fun build(): CustomLayerCloudwatchConfigurationArgs =
        CustomLayerCloudwatchConfigurationArgs(
            enabled = enabled,
            logStreams = logStreams,
        )
}
