@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin.inputs

import com.pulumi.aws.opsworks.inputs.CustomLayerCloudwatchConfigurationLogStreamArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property batchCount Specifies the max number of log events in a batch, up to `10000`. The default value is `1000`.
 * @property batchSize Specifies the maximum size of log events in a batch, in bytes, up to `1048576` bytes. The default value is `32768` bytes.
 * @property bufferDuration Specifies the time duration for the batching of log events. The minimum value is `5000` and default value is `5000`.
 * @property datetimeFormat Specifies how the timestamp is extracted from logs. For more information, see the CloudWatch Logs Agent Reference (https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AgentReference.html).
 * @property encoding Specifies the encoding of the log file so that the file can be read correctly. The default is `utf_8`.
 * @property file Specifies log files that you want to push to CloudWatch Logs. File can point to a specific file or multiple files (by using wild card characters such as /var/log/system.log*).
 * @property fileFingerprintLines Specifies the range of lines for identifying a file. The valid values are one number, or two dash-delimited numbers, such as `1`, `2-5`. The default value is `1`.
 * @property initialPosition Specifies where to start to read data (`start_of_file` or `end_of_file`). The default is `start_of_file`.
 * @property logGroupName Specifies the destination log group. A log group is created automatically if it doesn't already exist.
 * @property multilineStartPattern Specifies the pattern for identifying the start of a log message.
 * @property timeZone Specifies the time zone of log event time stamps.
 */
public data class CustomLayerCloudwatchConfigurationLogStreamArgs(
    public val batchCount: Output<Int>? = null,
    public val batchSize: Output<Int>? = null,
    public val bufferDuration: Output<Int>? = null,
    public val datetimeFormat: Output<String>? = null,
    public val encoding: Output<String>? = null,
    public val `file`: Output<String>,
    public val fileFingerprintLines: Output<String>? = null,
    public val initialPosition: Output<String>? = null,
    public val logGroupName: Output<String>,
    public val multilineStartPattern: Output<String>? = null,
    public val timeZone: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.opsworks.inputs.CustomLayerCloudwatchConfigurationLogStreamArgs> {
    override fun toJava(): com.pulumi.aws.opsworks.inputs.CustomLayerCloudwatchConfigurationLogStreamArgs =
        com.pulumi.aws.opsworks.inputs.CustomLayerCloudwatchConfigurationLogStreamArgs.builder()
            .batchCount(batchCount?.applyValue({ args0 -> args0 }))
            .batchSize(batchSize?.applyValue({ args0 -> args0 }))
            .bufferDuration(bufferDuration?.applyValue({ args0 -> args0 }))
            .datetimeFormat(datetimeFormat?.applyValue({ args0 -> args0 }))
            .encoding(encoding?.applyValue({ args0 -> args0 }))
            .`file`(`file`.applyValue({ args0 -> args0 }))
            .fileFingerprintLines(fileFingerprintLines?.applyValue({ args0 -> args0 }))
            .initialPosition(initialPosition?.applyValue({ args0 -> args0 }))
            .logGroupName(logGroupName.applyValue({ args0 -> args0 }))
            .multilineStartPattern(multilineStartPattern?.applyValue({ args0 -> args0 }))
            .timeZone(timeZone?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomLayerCloudwatchConfigurationLogStreamArgs].
 */
@PulumiTagMarker
public class CustomLayerCloudwatchConfigurationLogStreamArgsBuilder internal constructor() {
    private var batchCount: Output<Int>? = null

    private var batchSize: Output<Int>? = null

    private var bufferDuration: Output<Int>? = null

    private var datetimeFormat: Output<String>? = null

    private var encoding: Output<String>? = null

    private var `file`: Output<String>? = null

    private var fileFingerprintLines: Output<String>? = null

    private var initialPosition: Output<String>? = null

    private var logGroupName: Output<String>? = null

    private var multilineStartPattern: Output<String>? = null

    private var timeZone: Output<String>? = null

    /**
     * @param value Specifies the max number of log events in a batch, up to `10000`. The default value is `1000`.
     */
    @JvmName("cvrkborvfyvaluku")
    public suspend fun batchCount(`value`: Output<Int>) {
        this.batchCount = value
    }

    /**
     * @param value Specifies the maximum size of log events in a batch, in bytes, up to `1048576` bytes. The default value is `32768` bytes.
     */
    @JvmName("isaiemurbrsaeeps")
    public suspend fun batchSize(`value`: Output<Int>) {
        this.batchSize = value
    }

    /**
     * @param value Specifies the time duration for the batching of log events. The minimum value is `5000` and default value is `5000`.
     */
    @JvmName("pcoglubmbllyalry")
    public suspend fun bufferDuration(`value`: Output<Int>) {
        this.bufferDuration = value
    }

    /**
     * @param value Specifies how the timestamp is extracted from logs. For more information, see the CloudWatch Logs Agent Reference (https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AgentReference.html).
     */
    @JvmName("qqamvhttxnnkeyci")
    public suspend fun datetimeFormat(`value`: Output<String>) {
        this.datetimeFormat = value
    }

    /**
     * @param value Specifies the encoding of the log file so that the file can be read correctly. The default is `utf_8`.
     */
    @JvmName("cabiraberwkikqes")
    public suspend fun encoding(`value`: Output<String>) {
        this.encoding = value
    }

    /**
     * @param value Specifies log files that you want to push to CloudWatch Logs. File can point to a specific file or multiple files (by using wild card characters such as /var/log/system.log*).
     */
    @JvmName("dqubnofdvotscmir")
    public suspend fun `file`(`value`: Output<String>) {
        this.`file` = value
    }

    /**
     * @param value Specifies the range of lines for identifying a file. The valid values are one number, or two dash-delimited numbers, such as `1`, `2-5`. The default value is `1`.
     */
    @JvmName("qjlnaiieeewmivnh")
    public suspend fun fileFingerprintLines(`value`: Output<String>) {
        this.fileFingerprintLines = value
    }

    /**
     * @param value Specifies where to start to read data (`start_of_file` or `end_of_file`). The default is `start_of_file`.
     */
    @JvmName("iakvcnyikbfqukto")
    public suspend fun initialPosition(`value`: Output<String>) {
        this.initialPosition = value
    }

    /**
     * @param value Specifies the destination log group. A log group is created automatically if it doesn't already exist.
     */
    @JvmName("gnccvbbtkootfkam")
    public suspend fun logGroupName(`value`: Output<String>) {
        this.logGroupName = value
    }

    /**
     * @param value Specifies the pattern for identifying the start of a log message.
     */
    @JvmName("jmdlktxafgfqyrga")
    public suspend fun multilineStartPattern(`value`: Output<String>) {
        this.multilineStartPattern = value
    }

    /**
     * @param value Specifies the time zone of log event time stamps.
     */
    @JvmName("thlbiuantebexonu")
    public suspend fun timeZone(`value`: Output<String>) {
        this.timeZone = value
    }

    /**
     * @param value Specifies the max number of log events in a batch, up to `10000`. The default value is `1000`.
     */
    @JvmName("nbowbpjeqmfunslw")
    public suspend fun batchCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.batchCount = mapped
    }

    /**
     * @param value Specifies the maximum size of log events in a batch, in bytes, up to `1048576` bytes. The default value is `32768` bytes.
     */
    @JvmName("okheyahfiplelqwq")
    public suspend fun batchSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.batchSize = mapped
    }

    /**
     * @param value Specifies the time duration for the batching of log events. The minimum value is `5000` and default value is `5000`.
     */
    @JvmName("bowkrdogcxtkukty")
    public suspend fun bufferDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bufferDuration = mapped
    }

    /**
     * @param value Specifies how the timestamp is extracted from logs. For more information, see the CloudWatch Logs Agent Reference (https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AgentReference.html).
     */
    @JvmName("ycpllriwojhwhtmt")
    public suspend fun datetimeFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datetimeFormat = mapped
    }

    /**
     * @param value Specifies the encoding of the log file so that the file can be read correctly. The default is `utf_8`.
     */
    @JvmName("mfkpwsiujyyuhufy")
    public suspend fun encoding(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encoding = mapped
    }

    /**
     * @param value Specifies log files that you want to push to CloudWatch Logs. File can point to a specific file or multiple files (by using wild card characters such as /var/log/system.log*).
     */
    @JvmName("ptedbsuiikynyybh")
    public suspend fun `file`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`file` = mapped
    }

    /**
     * @param value Specifies the range of lines for identifying a file. The valid values are one number, or two dash-delimited numbers, such as `1`, `2-5`. The default value is `1`.
     */
    @JvmName("umuthfyfdqogpwea")
    public suspend fun fileFingerprintLines(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileFingerprintLines = mapped
    }

    /**
     * @param value Specifies where to start to read data (`start_of_file` or `end_of_file`). The default is `start_of_file`.
     */
    @JvmName("tktyajasbsatjpva")
    public suspend fun initialPosition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initialPosition = mapped
    }

    /**
     * @param value Specifies the destination log group. A log group is created automatically if it doesn't already exist.
     */
    @JvmName("nhwnmeeefrswppld")
    public suspend fun logGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logGroupName = mapped
    }

    /**
     * @param value Specifies the pattern for identifying the start of a log message.
     */
    @JvmName("yebgnnfrvjurkvoa")
    public suspend fun multilineStartPattern(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multilineStartPattern = mapped
    }

    /**
     * @param value Specifies the time zone of log event time stamps.
     */
    @JvmName("rjubregbadyucopc")
    public suspend fun timeZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeZone = mapped
    }

    internal fun build(): CustomLayerCloudwatchConfigurationLogStreamArgs =
        CustomLayerCloudwatchConfigurationLogStreamArgs(
            batchCount = batchCount,
            batchSize = batchSize,
            bufferDuration = bufferDuration,
            datetimeFormat = datetimeFormat,
            encoding = encoding,
            `file` = `file` ?: throw PulumiNullFieldException("file"),
            fileFingerprintLines = fileFingerprintLines,
            initialPosition = initialPosition,
            logGroupName = logGroupName ?: throw PulumiNullFieldException("logGroupName"),
            multilineStartPattern = multilineStartPattern,
            timeZone = timeZone,
        )
}
