@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin.inputs

import com.pulumi.aws.opsworks.inputs.CustomLayerLoadBasedAutoScalingDownscalingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property alarms Custom Cloudwatch auto scaling alarms, to be used as thresholds. This parameter takes a list of up to five alarm names, which are case sensitive and must be in the same region as the stack.
 * @property cpuThreshold The CPU utilization threshold, as a percent of the available CPU. A value of -1 disables the threshold.
 * @property ignoreMetricsTime The amount of time (in minutes) after a scaling event occurs that AWS OpsWorks Stacks should ignore metrics and suppress additional scaling events.
 * @property instanceCount The number of instances to add or remove when the load exceeds a threshold.
 * @property loadThreshold The load threshold. A value of -1 disables the threshold.
 * @property memoryThreshold The memory utilization threshold, as a percent of the available memory. A value of -1 disables the threshold.
 * @property thresholdsWaitTime The amount of time, in minutes, that the load must exceed a threshold before more instances are added or removed.
 */
public data class CustomLayerLoadBasedAutoScalingDownscalingArgs(
    public val alarms: Output<List<String>>? = null,
    public val cpuThreshold: Output<Double>? = null,
    public val ignoreMetricsTime: Output<Int>? = null,
    public val instanceCount: Output<Int>? = null,
    public val loadThreshold: Output<Double>? = null,
    public val memoryThreshold: Output<Double>? = null,
    public val thresholdsWaitTime: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.opsworks.inputs.CustomLayerLoadBasedAutoScalingDownscalingArgs> {
    override fun toJava(): com.pulumi.aws.opsworks.inputs.CustomLayerLoadBasedAutoScalingDownscalingArgs =
        com.pulumi.aws.opsworks.inputs.CustomLayerLoadBasedAutoScalingDownscalingArgs.builder()
            .alarms(alarms?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .cpuThreshold(cpuThreshold?.applyValue({ args0 -> args0 }))
            .ignoreMetricsTime(ignoreMetricsTime?.applyValue({ args0 -> args0 }))
            .instanceCount(instanceCount?.applyValue({ args0 -> args0 }))
            .loadThreshold(loadThreshold?.applyValue({ args0 -> args0 }))
            .memoryThreshold(memoryThreshold?.applyValue({ args0 -> args0 }))
            .thresholdsWaitTime(thresholdsWaitTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomLayerLoadBasedAutoScalingDownscalingArgs].
 */
@PulumiTagMarker
public class CustomLayerLoadBasedAutoScalingDownscalingArgsBuilder internal constructor() {
    private var alarms: Output<List<String>>? = null

    private var cpuThreshold: Output<Double>? = null

    private var ignoreMetricsTime: Output<Int>? = null

    private var instanceCount: Output<Int>? = null

    private var loadThreshold: Output<Double>? = null

    private var memoryThreshold: Output<Double>? = null

    private var thresholdsWaitTime: Output<Int>? = null

    /**
     * @param value Custom Cloudwatch auto scaling alarms, to be used as thresholds. This parameter takes a list of up to five alarm names, which are case sensitive and must be in the same region as the stack.
     */
    @JvmName("uxcmenntpyitxnee")
    public suspend fun alarms(`value`: Output<List<String>>) {
        this.alarms = value
    }

    @JvmName("pmtrwmgcnwryoryq")
    public suspend fun alarms(vararg values: Output<String>) {
        this.alarms = Output.all(values.asList())
    }

    /**
     * @param values Custom Cloudwatch auto scaling alarms, to be used as thresholds. This parameter takes a list of up to five alarm names, which are case sensitive and must be in the same region as the stack.
     */
    @JvmName("aoholndnjsotafbn")
    public suspend fun alarms(values: List<Output<String>>) {
        this.alarms = Output.all(values)
    }

    /**
     * @param value The CPU utilization threshold, as a percent of the available CPU. A value of -1 disables the threshold.
     */
    @JvmName("tcdksyaiyuaittkd")
    public suspend fun cpuThreshold(`value`: Output<Double>) {
        this.cpuThreshold = value
    }

    /**
     * @param value The amount of time (in minutes) after a scaling event occurs that AWS OpsWorks Stacks should ignore metrics and suppress additional scaling events.
     */
    @JvmName("pilfhqxknmtcofxe")
    public suspend fun ignoreMetricsTime(`value`: Output<Int>) {
        this.ignoreMetricsTime = value
    }

    /**
     * @param value The number of instances to add or remove when the load exceeds a threshold.
     */
    @JvmName("eggivafskxycomct")
    public suspend fun instanceCount(`value`: Output<Int>) {
        this.instanceCount = value
    }

    /**
     * @param value The load threshold. A value of -1 disables the threshold.
     */
    @JvmName("rvxelxyvilksbfhd")
    public suspend fun loadThreshold(`value`: Output<Double>) {
        this.loadThreshold = value
    }

    /**
     * @param value The memory utilization threshold, as a percent of the available memory. A value of -1 disables the threshold.
     */
    @JvmName("lefqsicfpfrddyku")
    public suspend fun memoryThreshold(`value`: Output<Double>) {
        this.memoryThreshold = value
    }

    /**
     * @param value The amount of time, in minutes, that the load must exceed a threshold before more instances are added or removed.
     */
    @JvmName("yftuvbjwchvbclmh")
    public suspend fun thresholdsWaitTime(`value`: Output<Int>) {
        this.thresholdsWaitTime = value
    }

    /**
     * @param value Custom Cloudwatch auto scaling alarms, to be used as thresholds. This parameter takes a list of up to five alarm names, which are case sensitive and must be in the same region as the stack.
     */
    @JvmName("gbhdxthmwiwfsbbk")
    public suspend fun alarms(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alarms = mapped
    }

    /**
     * @param values Custom Cloudwatch auto scaling alarms, to be used as thresholds. This parameter takes a list of up to five alarm names, which are case sensitive and must be in the same region as the stack.
     */
    @JvmName("taoxflysebhtunfm")
    public suspend fun alarms(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alarms = mapped
    }

    /**
     * @param value The CPU utilization threshold, as a percent of the available CPU. A value of -1 disables the threshold.
     */
    @JvmName("jablljfqfsmxppwm")
    public suspend fun cpuThreshold(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpuThreshold = mapped
    }

    /**
     * @param value The amount of time (in minutes) after a scaling event occurs that AWS OpsWorks Stacks should ignore metrics and suppress additional scaling events.
     */
    @JvmName("pnfpdhpwfytjwajv")
    public suspend fun ignoreMetricsTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreMetricsTime = mapped
    }

    /**
     * @param value The number of instances to add or remove when the load exceeds a threshold.
     */
    @JvmName("mvbeexbwaiemtuoq")
    public suspend fun instanceCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceCount = mapped
    }

    /**
     * @param value The load threshold. A value of -1 disables the threshold.
     */
    @JvmName("blkhmpqrxbmwfqse")
    public suspend fun loadThreshold(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadThreshold = mapped
    }

    /**
     * @param value The memory utilization threshold, as a percent of the available memory. A value of -1 disables the threshold.
     */
    @JvmName("xksoytsrubnektwh")
    public suspend fun memoryThreshold(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memoryThreshold = mapped
    }

    /**
     * @param value The amount of time, in minutes, that the load must exceed a threshold before more instances are added or removed.
     */
    @JvmName("wrpnqkmwkygvfomp")
    public suspend fun thresholdsWaitTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thresholdsWaitTime = mapped
    }

    internal fun build(): CustomLayerLoadBasedAutoScalingDownscalingArgs =
        CustomLayerLoadBasedAutoScalingDownscalingArgs(
            alarms = alarms,
            cpuThreshold = cpuThreshold,
            ignoreMetricsTime = ignoreMetricsTime,
            instanceCount = instanceCount,
            loadThreshold = loadThreshold,
            memoryThreshold = memoryThreshold,
            thresholdsWaitTime = thresholdsWaitTime,
        )
}
